% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Windham.R
\name{Windham_populationinverse}
\alias{Windham_populationinverse}
\alias{Windham_populationinverse_alternative}
\title{Inverse Transform for the Population Parameters Under Windham Weights}
\usage{
Windham_populationinverse(cW)

Windham_populationinverse_alternative(newtheta, previoustheta, cW, cWav)
}
\arguments{
\item{cW}{A vector of tuning constants for the Windham robustification method performed by \code{\link[=Windham]{Windham()}}.}

\item{newtheta}{The parameter vector most recently estimated}

\item{previoustheta}{The parameter vector estimated in the previous step}

\item{cWav}{The value of the non-zero elements of \code{cW}. That is \code{cW} have elements that are zero or equal to \code{cWav}.}
}
\value{
A diagonal matrix with the same number of columns as \code{cW}.
}
\description{
Returns the matrix which reverses the effect of weights on a population for certain models.
}
\details{
In the Windham robustification method (\code{\link[=Windham]{Windham()}}) the effect of weighting a population plays a central role.
When the
the model density is proportional to \eqn{\exp(\eta(\theta) \cdot T(u))},
where \eqn{T(u)} is a vector of sufficient statistics for a measurement \eqn{u},
and \eqn{\eta} is a \emph{linear} function,
Then weights proportional to
\eqn{\exp(\eta(c \circ \theta) \cdot t(u))},
where \eqn{c} is a vector of tuning constants and \eqn{\circ} is the Hadamard (element-wise) product,
have a very simple effect on the population parameter vector \eqn{\theta}:
the weighted population follows a density of the same form, but with a parameter vector of
\eqn{(1 + c) \circ \theta}.
The inverse of this change to the parameter vector is then a matrix multiplication by a diagonal matrix with elements \eqn{1/(1+c_i)}, with \eqn{c_i} denoting the elements of \eqn{c}.
}
\section{Functions}{
\itemize{
\item \code{Windham_populationinverse}: The matrix with diagonal elements \eqn{1/(1+c_i)}

\item \code{Windham_populationinverse_alternative}: The transform implemented as described by \insertCite{scealy2024ro;textual}{scorematchingad}. It is mathematically equivalent to multiplication by the result of \code{Windham_populationinverse()} in the situation in \insertCite{scealy2024ro;textual}{scorematchingad}.
}}

