% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/tape_uld.R
\name{tape_uld}
\alias{tape_uld}
\alias{tape_uld_inbuilt}
\title{Generate a tape of a custom unnormalised log-density}
\usage{
tape_uld_inbuilt(name, x, theta)

tape_uld(fileORcode = "", x, theta, Cppopt = NULL)
}
\arguments{
\item{name}{Name of an inbuilt function. See details.}

\item{x}{Value of independent variables for taping.}

\item{theta}{Value of the dynamic parameter vector for taping.}

\item{fileORcode}{A character string giving the path name of a file containing the unnormalised log-density definition \emph{OR} code. \code{fileORcode} will be treated as a file name if \code{fileORcode} contains no new line characters ('\\n' or '\\r\\n') and has a file extension detected by \code{\link[tools:fileutils]{tools::file_ext()}}.}

\item{Cppopt}{List of named options passed to \code{Rcpp::sourceCpp()}}
}
\value{
A list of three objects
\itemize{
\item \code{fun} a function that evaluates the function directly
\item \code{tape} a tape of the function
\item \code{file} the temporary file storing the final source code passed to \code{\link[Rcpp:sourceCpp]{Rcpp::sourceCpp()}}
}
}
\description{
Generate tapes of unnormalised log-densities.
Use \code{tape_ult()} to specify a custom unnormalised log-density using \verb{C++} code much like \code{TMB::compile()}.
Use \code{tape_uld_inbuilt()} for tapes of inbuilt unnormalised log-densities implemented in this package.
}
\details{
For \code{tape_uld_inbuilt()}, currently available unnormalised log-density functions are:
\itemize{
\item dirichlet
\item ppi
\item vMF
\item Bingham
\item FB
}

The function \code{tape_uld()} uses \code{\link[Rcpp:sourceCpp]{Rcpp::sourceCpp()}} to generate a tape of a function defined in C++.
(An alternative design, where the function is compiled interactively and then taped using a function internal to \code{scorematchingad}, was not compatible with Windows OS).

The result result is NOT safe to save or pass to other CPUs in a parallel operation.
}
\section{Writing the \code{fileORcode} Argument}{
The code (possibly in the file pointed to by \code{fileORcode}) must be \verb{C++} that uses only \code{CppAD} and \code{Eigen}, which makes it very similar to the requirements of the input to \code{TMB::compile()} (which also uses \code{CppAD} and \code{Eigen}).

The start of \code{code} should always be "\verb{a1type fname(const veca1 &x, const veca1 &theta)\{}" where \code{fname} is your chosen name of the log-density function, \code{x} represents a point in the data space and \code{theta} is a vector of parameters for the log-density. This specifies that the function will have two vector arguments (of type \code{veca1}) and will return a single numeric value (\code{a1type}).

The type \code{a1type} is a double with special ability for being taped by \code{CppAD}. The \code{veca1} type is a vector of \code{a1type} elements, with the vector wrapping supplied by the \code{Eigen} C++ package (that is an \code{Eigen} matrix with 1 column and dynamic number of rows).

The body of the function must use operations from Eigen and/or CppAD, prefixed by \verb{Eigen::} and \verb{CppAD::} respectively.
There are no easy instructions for writing these as it is genuine \verb{C++} code, which can be very opaque to those unfamiliar with \verb{C++}.
However, recently ChatGPT and claude.ai have been able to very quickly translating \code{R} functions to \verb{C++} functions (KLH has been telling these A.I. to use Eigen and CppAD, and giving the definitions of \code{a1type} and \code{veca1}).
I've found the quick reference pages for for \href{https://eigen.tuxfamily.org/dox/}{\code{Eigen}} useful. Limited unary and binary operations are available directly from \href{https://cppad.readthedocs.io}{\code{CppAD}} without \code{Eigen}.
For the purposes of score matching the operations should all be smooth to create a smooth log-density and the normalising constant may be omitted.
}

\examples{
\dontrun{
out <- tape_uld(system.file("demo_custom_uld.cpp", package = "scorematchingad"), 
                rep(0.2, 5), rep(-0.1, 5))
out$fun(c(0.1, 0.2, 0.2, 0.2, 0.2), c(-0.5, -0.5, -0.1, -0.1, 0))
out$tape$eval(c(0.1, 0.2, 0.2, 0.2, 0.2), c(-0.5, -0.5, -0.1, -0.1, 0))
out$tape$Jac(c(0.1, 0.2, 0.2, 0.2, 0.2), c(-0.5, -0.5, -0.1, -0.1, 0))
out$tape$name
}
}
\seealso{
Other tape builders: 
\code{\link{tape_Hessian}()},
\code{\link{tape_Jacobian}()},
\code{\link{tape_gradoffset}()},
\code{\link{tape_logJacdet}()},
\code{\link{tape_smd}()},
\code{\link{tape_swap}()}
}
\concept{tape builders}
