% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/absolute_error.R
\name{ae_median_quantile}
\alias{ae_median_quantile}
\title{Absolute Error of the Median (Quantile-based Version)}
\usage{
ae_median_quantile(true_values, predictions, quantiles = NULL, verbose = TRUE)
}
\arguments{
\item{true_values}{A vector with the true observed values of size n}

\item{predictions}{numeric vector with predictions, corresponding to the
quantiles in a second vector, `quantiles`.}

\item{quantiles}{numeric vector that denotes the quantile for the values
in `predictions`. Only those predictions where `quantiles == 0.5` will
be kept. If `quantiles` is `NULL`, then all `predictions` and
`true_values` will be used (this is then the same as `absolute_error()`)}

\item{verbose}{logical, return a warning is something unexpected happens}
}
\value{
vector with the scoring values
}
\description{
Absolute error of the median calculated as

\deqn{
  abs(true_value - median_prediction)
}
}
\examples{
true_values <- rnorm(30, mean = 1:30)
predicted_values <- rnorm(30, mean = 1:30)
ae_median_quantile(true_values, predicted_values, quantiles = 0.5)
}
