% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brier_score.R
\name{brier_score}
\alias{brier_score}
\title{Brier Score}
\usage{
brier_score(true_values, predictions)
}
\arguments{
\item{true_values}{A vector with the true observed values of size n}

\item{predictions}{A vector with a predicted probability
that true_value = 1.}
}
\value{
A numeric value with the Brier Score, i.e. the mean squared
error of the given probability forecasts
}
\description{
Computes the Brier Score for probabilistic forecasts of binary outcomes.
}
\details{
The Brier score is a proper score rule that assesses the accuracy of
probabilistic binary predictions. The outcomes can be either 0 or 1,
the predictions must be a probability that the true outcome will be 1.

The Brier Score is then computed as the mean squared error between the
probabilistic prediction and the true outcome.

\deqn{
Brier_Score = \frac{1}{N} \sum_{t = 1}^{n} (prediction_t - outcome_t)^2
}
}
\examples{
true_values <- sample(c(0,1), size = 30, replace = TRUE)
predictions <- runif(n = 30, min = 0, max = 1)

brier_score(true_values, predictions)

}
