% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics_point_forecasts.R
\name{abs_error}
\alias{abs_error}
\title{Absolute Error}
\usage{
abs_error(true_values, predictions)
}
\arguments{
\item{true_values}{A vector with the true observed values of size n}

\item{predictions}{numeric vector with predictions, corresponding to the
quantiles in a second vector, \code{quantiles}.}
}
\value{
vector with the absolute error
}
\description{
Calculate absolute error as

\deqn{
  \textrm{abs}(\textrm{true\_value} - \textrm{median\_prediction})
}{
  abs(true_value - prediction)
}
}
\examples{
true_values <- rnorm(30, mean = 1:30)
predicted_values <- rnorm(30, mean = 1:30)
abs_error(true_values, predicted_values)
}
\seealso{
\code{\link[=ae_median_sample]{ae_median_sample()}}, \code{\link[=ae_median_quantile]{ae_median_quantile()}}
}
\keyword{metric}
