% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/avail_forecasts.R
\name{avail_forecasts}
\alias{avail_forecasts}
\title{Display Number of Forecasts Available}
\usage{
avail_forecasts(data, by = NULL, collapse = c("quantile", "sample"))
}
\arguments{
\item{data}{data.frame with predictions in the same format required for
\code{\link[=score]{score()}}.}

\item{by}{character vector or \code{NULL} (the default) that denotes the
categories over which the number of forecasts should be counted.
By default (\code{by = NULL}) this will be the unit of a single forecast (i.e.
all available columns (apart from a few "protected" columns such as
'prediction' and 'true value') plus "quantile" or "sample" where present).}

\item{collapse}{character vector (default is \verb{c("quantile", "sample"}) with
names of categories for which the number of rows should be collapsed to one
when counting. For example, a single forecast is usually represented by a
set of several quantiles or samples and collapsing these to one makes sure
that a single forecast only gets counted once.}
}
\value{
A data.table with columns as specified in \code{by} and an additional
column with the number of forecasts.
}
\description{
Given a data set with forecasts, count the number of available forecasts
for arbitrary grouping (e.g. the number of forecasts per model, or the
number of forecasts per model and location).
This is useful to determine whether there are any missing forecasts.
}
\examples{
avail_forecasts(example_quantile,
  collapse = c("quantile"),
  by = c("model", "target_type")
)
}
\keyword{check-forecasts}
