% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-scores.R
\name{get_metrics.scores}
\alias{get_metrics.scores}
\title{Get names of the metrics that were used for scoring}
\usage{
\method{get_metrics}{scores}(x, error = FALSE, ...)
}
\arguments{
\item{x}{A \code{scores} object, (a data.table with an attribute \code{metrics} as
produced by \code{\link[=score]{score()}}).}

\item{error}{Throw an error if there is no attribute called \code{metrics}?
Default is FALSE.}

\item{...}{unused}
}
\value{
Character vector with the names of the scoring rules that were used
for scoring.
}
\description{
When applying a scoring rule via \code{\link[=score]{score()}}, the names of the scoring rules
become column names of the
resulting data.table. In addition, an attribute \code{metrics} will be
added to the output, holding the names of the scores as a vector.

This is done so that functions like \code{\link[=get_forecast_unit]{get_forecast_unit()}} or
\code{\link[=summarise_scores]{summarise_scores()}} can still identify which columns are part of the
forecast unit and which hold a score.

\code{get_metrics()} accesses and returns the \code{metrics} attribute. If there is no
attribute, the function will return \code{NULL} (or, if \code{error = TRUE} will
produce an error instead). In addition, it checks the column names of the
input for consistency with the data stored in the \code{metrics} attribute.

\strong{Handling a missing or inconsistent \code{metrics} attribute}:

If the metrics attribute is missing or is not consistent with the column
names of the data.table, you can either
\itemize{
\item run \code{\link[=score]{score()}} again, specifying names for the scoring rules manually, or
\item add/update the attribute manually using
\code{attr(scores, "metrics") <- c("names", "of", "your", "scores")} (the
order does not matter).
}
}
\seealso{
Other get_metrics functions: 
\code{\link{get_metrics}()},
\code{\link{get_metrics.forecast_binary}()},
\code{\link{get_metrics.forecast_nominal}()},
\code{\link{get_metrics.forecast_ordinal}()},
\code{\link{get_metrics.forecast_point}()},
\code{\link{get_metrics.forecast_quantile}()},
\code{\link{get_metrics.forecast_sample}()}
}
\concept{get_metrics functions}
\keyword{handle-metrics}
