% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scphaser.R
\name{filter_feat_nminvar}
\alias{filter_feat_nminvar}
\title{Filter features on minimal number of required variants}
\usage{
filter_feat_nminvar(acset, nmin_var = 2)
}
\arguments{
\item{acset}{An acset list created by the function \code{\link{new_acset}}.}

\item{nmin_var}{An integer specifying the minimum number of variants within
a feature}
}
\value{
acset An acset list. The element [['filter']][['nmin_var']] is added
or updated to the acset to record the filter argument used.
}
\description{
\code{filter_feat_nminvar} removes features with less than "nmin_var"
variants.
}
\details{
The function takes an acset and an integer, "nmin_var", as input and filter
out features that have less than "nmin_var" variants.
}
\examples{
##create a small artificial genotype matrix
ncells = 10
paternal = c(0, 2, 0, 0, 2)
maternal = c(2, 0, 2, 2, 0)
gt = as.matrix(as.data.frame(rep(list(paternal, maternal), ncells / 2)))
vars = 1:nrow(gt)
colnames(gt) = 1:ncells
rownames(gt) = vars

##create a feature annotation data-frame
nvars = nrow(gt)
featdata = as.data.frame(matrix(cbind(rep('jfeat', nvars),
as.character(1:nvars), rep('dummy', nvars), rep('dummy', nvars)), ncol = 4,
dimnames = list(vars, c('feat', 'var', 'ref', 'alt'))), stringsAsFactors =
FALSE)

##create acset
acset = new_acset(featdata, gt = gt)

##Remove features with less than nminvar variants
nminvar = 2
acset = filter_feat_nminvar(acset, nminvar)

}

