% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dedup.R
\name{dedup}
\alias{dedup}
\title{Deduplicate records}
\usage{
dedup(x, how = "one", tolerance = 0.9)
}
\arguments{
\item{x}{(data.frame) A data.frame, tibble, or data.table}

\item{how}{(character) How to deal with duplicates. The default of
"one" keeps one record of each group of duplicates, and drops the
others, putting them into the \code{dups} attribute. "all" drops all
duplicates, in case e.g., you don't want to deal with any records that are
duplicated, as e.g., it may be hard to tell which one to remove.}

\item{tolerance}{(numeric) Score (0 to 1) at which to determine a match.
You'll want to inspect outputs closely to tweak this value based on your
data, as results can vary.}
}
\value{
Returns a data.frame, optionally with attributes
}
\description{
Deduplicate records
}
\examples{
df <- sample_data_1
smalldf <- df[1:20, ]
smalldf <- rbind(smalldf, smalldf[10,])
smalldf[21, "key"] <- 1088954555
NROW(smalldf)
dp <- dframe(smalldf) \%>\% dedup()
NROW(dp)
attr(dp, "dups")

# Another example - more than one set of duplicates
df <- sample_data_1
twodups <- df[1:10, ]
twodups <- rbind(twodups, twodups[c(9, 10), ])
rownames(twodups) <- NULL
NROW(twodups)
dp <- dframe(twodups) \%>\% dedup()
NROW(dp)
attr(dp, "dups")
}
