% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hier_display.R
\name{hier_display}
\alias{hier_display}
\title{Displays the hierarchy}
\usage{
hier_display(x, root = NULL)
}
\arguments{
\item{x}{a hierarchy object, either directly generated and modified using
\code{\link[=hier_create]{hier_create()}}, \code{\link[=hier_add]{hier_add()}}, \code{\link[=hier_delete]{hier_delete()}} and/or \code{\link[=hier_rename]{hier_rename()}} or
objects converted using \code{\link[=hier_convert]{hier_convert()}}}

\item{root}{\code{NULL} if the entire tree should be printed or a name of
a node which is used as temporary root-node for printing}
}
\value{
\code{NULL}; the tree is printed to the prompt
}
\description{
This function shows the entire hierarchy in a nice way.
}
\examples{
h <- hier_create(root = "Total", nodes = LETTERS[1:2])
h <- hier_add(h, root = "A", nodes = c("a1", "a2"))

# display the entire tree
hier_display(h)

# display only a subtree
hier_display(h, root = "A")
}
