% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/0classes.r, R/aux_functions.r, R/methods.r
\docType{class}
\name{sdcMicroObj-class}
\alias{createSdcObj}
\alias{get.sdcMicroObj}
\alias{get.sdcMicroObj,sdcMicroObj,character-method}
\alias{nextSdcObj}
\alias{nextSdcObj,sdcMicroObj-method,}
\alias{sdcMicroObj-class}
\alias{set.sdcMicroObj}
\alias{set.sdcMicroObj,sdcMicroObj,character,listOrNULL-method}
\alias{show}
\alias{show,sdcMicroObj-method}
\alias{undolast}
\alias{undolast,sdcMicroObj-method}
\title{Class \code{"sdcMicroObj"}}
\usage{
createSdcObj(dat, keyVars, numVars = NULL, pramVars = NULL,
  ghostVars = NULL, weightVar = NULL, hhId = NULL, strataVar = NULL,
  sensibleVar = NULL, options = NULL)

get.sdcMicroObj(object, type)

set.sdcMicroObj(object, type, input)

undolast(object)

\S4method{get.sdcMicroObj}{sdcMicroObj,character}(object, type)

\S4method{set.sdcMicroObj}{sdcMicroObj,character,listOrNULL}(object, type,
  input)

\S4method{undolast}{sdcMicroObj}(object)
}
\arguments{
\item{dat}{The microdata set. A numeric matrix or data frame containing the data.}

\item{keyVars}{Indices or names of categorical key variables. They must, of
course, match with the columns of \sQuote{dat}.}

\item{numVars}{Index or names of continuous key variables.}

\item{pramVars}{Indices or names of categorical variables considered to be pramed.}

\item{ghostVars}{if specified a list which each element being a list of exactly two elements.
The first element must be a character vector specifying exactly one variable name that was
also specified as a categorical key variable (\code{keyVars}), while the second element is
a character vector of valid variable names (that must not be listed as \code{keyVars}).
If \code{\link{localSuppression}} or \code{\link{kAnon}} was applied, the resulting
suppression pattern for each key-variable is transferred to the depending variables.}

\item{weightVar}{Indices or name determining the vector of sampling weights.}

\item{hhId}{Index or name of the cluster ID (if available).}

\item{strataVar}{Indices or names of stratification variables.}

\item{sensibleVar}{Indices or names of sensible variables (for l-diversity)}

\item{options}{additional options.}

\item{object}{an object of class \code{sdcMicroObj}}

\item{type}{a character vector of length 1 defining what to calculate|return|modify. Allowed types are:}
\itemize{
\item origData: set slot 'origData' of argument \code{object}}

\item{input}{a list depending on argument \code{type}.}
\itemize{
\item type==dataOrig: a list containing original microdata}
}
\value{
an object of class \code{sdcMicroObj}

an object of class \code{sdcMicroObj}
}
\description{
Class to save all information about the SDC process

modify \code{sdcMicroObj}-objects depending on argument \code{type}

undo last changes to \code{sdcMicroObj}-objects if possible
note that this will only work if the user makes use of the prev slot or uses the sdcMicroObj functions
}
\note{
internal function

internal function

internal function
}
\section{Objects from the Class}{
 Objects can be created by calls of the form
\code{new("sdcMicroObj", ...)}.
}
\examples{
showClass("sdcMicroObj")
\dontrun{
data(testdata)
sdc <- createSdcObj(testdata,
  keyVars=c('urbrur','roof','walls','water','electcon','relat','sex'),
  numVars=c('expend','income','savings'), w='sampling_weight')
head(sdc@manipNumVars)
### Display Risks
sdc@risk$global
sdc <- dRisk(sdc)
sdc@risk$numeric
### use addNoise without Parameters
sdc <- addNoise(sdc,variables=c("expend","income"))
head(sdc@manipNumVars)
sdc@risk$numeric
### undolast
sdc <- undolast(sdc)
head(sdc@manipNumVars)
sdc@risk$numeric
### redo addNoise with Parameter
sdc <- addNoise(sdc, noise=0.2)
head(sdc@manipNumVars)
sdc@risk$numeric
### dataGen
#sdc <- undolast(sdc)
#head(sdc@risk$individual)
#sdc@risk$global
#sdc <- dataGen(sdc)
#head(sdc@risk$individual)
#sdc@risk$global
### LocalSuppression
sdc <- undolast(sdc)
head(sdc@risk$individual)
sdc@risk$global
sdc <- localSuppression(sdc)
head(sdc@risk$individual)
sdc@risk$global
### microaggregation
sdc <- undolast(sdc)
head(get.sdcMicroObj(sdc, type="manipNumVars"))
sdc <- microaggregation(sdc)
head(get.sdcMicroObj(sdc, type="manipNumVars"))
### pram
sdc <- undolast(sdc)
head(sdc@risk$individual)
sdc@risk$global
sdc <- pram(sdc,keyVar="water")
head(sdc@risk$individual)
sdc@risk$global
### rankSwap
sdc <- undolast(sdc)
head(sdc@risk$individual)
sdc@risk$global
head(get.sdcMicroObj(sdc, type="manipNumVars"))
sdc <- rankSwap(sdc)
head(get.sdcMicroObj(sdc, type="manipNumVars"))
head(sdc@risk$individual)
sdc@risk$global
### suda2
sdc <- suda2(sdc)
sdc@risk$suda2
### topBotCoding
head(get.sdcMicroObj(sdc, type="manipNumVars"))
sdc@risk$numeric
sdc <- topBotCoding(sdc, value=60000000, replacement=62000000, column="income")
head(get.sdcMicroObj(sdc, type="manipNumVars"))
sdc@risk$numeric
### LocalRecProg
data(testdata2)
sdc <- createSdcObj(testdata2,
  keyVars=c("urbrur", "roof", "walls", "water", "sex", "relat"))
sdc@risk$global
sdc <- LocalRecProg(sdc)
sdc@risk$global
### LLmodGlobalRisk
sdc <- undolast(sdc)
sdc <- LLmodGlobalRisk(sdc, inclProb=0.001)
sdc@risk$model
}
## we can also specify ghost (linked) variables
## these variables are linked to some categorical key variables
## and have the sampe suppression pattern as the variable that they
## are linked to after \\code{\\link{localSuppression}} has been applied
data(testdata)
testdata$electcon2 <- testdata$electcon
testdata$electcon3 <- testdata$electcon
testdata$water2 <- testdata$water
keyVars <- c("urbrur","roof","walls","water","electcon","relat","sex")
numVars <- c("expend","income","savings")
w <- "sampling_weight"
## we want to make sure that some variables not used as key-variables
## have the same suppression pattern as variables that have been
## selected as key variables. Thus, we are using 'ghost'-variables.
ghostVars <- list()

## we want variables 'electcon2' and 'electcon3' to be linked
## to key-variable 'electcon'
ghostVars[[1]] <- list()
ghostVars[[1]][[1]] <- "electcon"
ghostVars[[1]][[2]] <- c("electcon2","electcon3")

## we want variable 'water2' to be linked to key-variable 'water'
ghostVars[[2]] <- list()
ghostVars[[2]][[1]] <- "water"
ghostVars[[2]][[2]] <- "water2"

## create the sdcMicroObj
obj <- createSdcObj(testdata, keyVars=keyVars,
  numVars=numVars, w=w, ghostVars=ghostVars)

## apply 3-anonymity to selected key variables
obj <- kAnon(obj, k=3); obj

## check, if the suppression patterns are identical
manipGhostVars <- get.sdcMicroObj(obj, "manipGhostVars")
manipKeyVars <- get.sdcMicroObj(obj, "manipKeyVars")
all(is.na(manipKeyVars$electcon) == is.na(manipGhostVars$electcon2))
all(is.na(manipKeyVars$electcon) == is.na(manipGhostVars$electcon3))
all(is.na(manipKeyVars$water) == is.na(manipGhostVars$water2))
}
\author{
Bernhard Meindl, Alexander Kowarik, Matthias Templ, Elias Rut

Bernhard Meindl \email{bernhard.meindl@statistik.gv.at}

Bernhard Meindl \email{bernhard.meindl@statistik.gv.at}

Elias Rut
}
\keyword{classes}

