% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/localSuppression.R
\name{plot.localSuppression}
\alias{plot.localSuppression}
\title{Plots for localSuppression objects}
\usage{
\method{plot}{localSuppression}(x, ...)
}
\arguments{
\item{x}{object of derived from \code{\link[=localSuppression]{localSuppression()}}}

\item{...}{Additional arguments, currently available are:
\itemize{
\item \code{"showDetails"}: logical, if set, a plot of suppressions by
strata is shown (if possible)
}}
}
\value{
a \code{ggplot} plot object
}
\description{
This function creates barplots to display the number of suppressed values
in categorical key variables to achieve \code{k}-anonymity.
}
\examples{
data(francdat)
l1 <- localSuppression(obj = francdat, k = 2, keyVars = c(2, 4:6))
l1
plot(l1)

## with details of suppression by strata
data(testdata2)
testdata2$ageG <- cut(testdata2$age, 5, labels = paste0("AG",1:5))
keyVars <- c("urbrur", "roof", "walls", "water", "electcon", "relat", "sex")
strataVars <- "ageG"
inp <- testdata2[, c(keyVars, strataVars)]
ls <- localSuppression(inp, keyVars = 1:7, strataVars = 8)
print(ls)
plot(ls)
plot(ls, showDetails = TRUE)
}
\seealso{
\code{\link[=localSuppression]{localSuppression()}}
}
\author{
Bernhard Meindl, Matthias Templ
}
\keyword{plot}
