% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_sensitive.R
\name{is_sensitive}
\alias{is_sensitive}
\title{Return raster with sensitive locations.}
\usage{
is_sensitive(
  x,
  max_risk = x$max_risk,
  min_count = x$min_count,
  risk_type = x$risk_type
)
}
\arguments{
\item{x}{\code{\link{sdc_raster}} object.}

\item{max_risk}{a risk value higher than \code{max_risk} will be sensitive.}

\item{min_count}{a count lower than \code{min_count} will be sensitive.}

\item{risk_type}{what kind of measure should be used (see details).}
}
\description{
Create a binary raster with sensitive locations.
}
\details{
By default the risk settings are taken from \code{x}, but they can be overriden.

Different risk functions can be used:
\itemize{
\item external (numeric variable), calculates how much the largest value comprises the total sum
\item internal (numeric variable), calculates how much the largest value comprises the sum without the second largest value
\item discrete (logical variable), calculates the fraction of sensitive values.
}
}
\examples{
\donttest{
dwellings_sp <- dwellings
sp::coordinates(dwellings_sp) <- ~ x + y
tryCatch(
  # does not work on some OS versions
  sp::proj4string(dwellings_sp) <- "+init=epsg:28992"
)
# create a 1km grid
unemployed <- sdc_raster(dwellings_sp, dwellings_sp$unemployed, r = 1e3)
print(unemployed)

# retrieve the sensitive cells
is_sensitive(unemployed)
}
}
\seealso{
Other sensitive: 
\code{\link{disclosure_risk}()},
\code{\link{is_sensitive_at}()},
\code{\link{plot_sensitive}()},
\code{\link{remove_sensitive}()},
\code{\link{sdc_raster}()},
\code{\link{sensitivity_score}()}
}
\concept{sensitive}
