% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdcSpatial-package.R
\docType{package}
\name{sdcSpatial-package}
\alias{sdcSpatial}
\alias{sdcSpatial-package}
\title{Privacy Protected maps}
\description{
\code{sdcSpatial} contains  functions to create spatial distribution maps,
assess the risk of disclosure on a location and to suppress or adjust
revealing values at certain locations.
}
\details{
\code{sdcSpatial} working horse is the \code{\link[=sdc_raster]{sdc_raster()}} object upon which the
following methods can be applied:
}
\section{Sensitivity assessment}{

\itemize{
\item \code{\link[=plot.sdc_raster]{plot.sdc_raster()}}, \code{\link[=plot_sensitive]{plot_sensitive()}}
\item \code{print}
\item \code{\link[=is_sensitive]{is_sensitive()}}
}
}

\section{Protection methods}{

\itemize{
\item \code{\link[=remove_sensitive]{remove_sensitive()}}
\item \code{\link[=protect_smooth]{protect_smooth()}}
\item \code{\link[=protect_quadtree]{protect_quadtree()}}
}
}

\section{Extraction}{

\itemize{
\item \code{sum}, extract the \code{sum} layer from a \code{sdc_raster} object
\item \code{mean}, extract the \code{mean} layer from a \code{sdc_raster} object
}
}

\references{
de Jonge, E., & de Wolf, P. P. (2016, September).
Spatial smoothing and statistical disclosure control.
In International Conference on Privacy in Statistical Databases (pp. 107-117). Springer, Cham.

de Wolf, P. P., & de Jonge, E. (2018, September).
Safely Plotting Continuous Variables on a Map. In International Conference
on Privacy in Statistical Databases (pp. 347-359). Springer, Cham.

Suñé, E., Rovira, C., Ibáñez, D., Farré, M. (2017). Statistical
disclosure control on visualising geocoded population data using
a structure in quadtrees, NTTS 2017
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/edwindj/sdcSpatial}
  \item Report bugs at \url{https://github.com/edwindj/sdcSpatial/issues}
}

}
\author{
\strong{Maintainer}: Edwin de Jonge \email{edwindjonge@gmail.com} (\href{https://orcid.org/0000-0002-6580-4718}{ORCID})

Authors:
\itemize{
  \item Peter-Paul de Wolf
}

Other contributors:
\itemize{
  \item Douwe Hut [contributor]
  \item Sapphire Han [contributor]
}

}
