% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setInfo.R
\name{setInfo}
\alias{setInfo}
\title{Set/Update information in \code{sdcProblem} or \code{problemInstance} objects}
\usage{
setInfo(object, type, index, input)
}
\arguments{
\item{object}{an object of class \code{sdcProblem} or \code{problemInstance}}

\item{type}{a scalar character specifying the kind of information that
should be changed or modified; if \code{object} inherits class \code{problemInstance}, the
slots are directly changed, otherwise the values within slot \code{problemInstance}
are updated. Valid choices are:
\itemize{
\item \code{lb}: lower possible bounds for the cell
\item \code{ub}: max. upper bound for the given cell
\item \code{LPL}: lower protection level
\item \code{SPL}: sliding protection level
\item \code{UPL}: upper protection level
\item \code{sdcStatus}:  cell-status
}}

\item{index}{numeric vector defining cell-indices for which which values in a specified slot should be changed|modified}

\item{input}{numeric or character vector depending on argument \code{type} with its length matching the length of argument \code{index}
\itemize{
\item character vector if type matches 'sdcStatus'
\item a numeric vector if type matches 'lb', 'ub', 'LPL', 'SPL' or 'UPL'
}}
}
\value{
a \code{sdcProblem}- or \code{problemInstance} object
}
\description{
Function \code{\link[=setInfo]{setInfo()}} is used to update values in
\code{sdcProblem} or \code{problemInstance} objects
}
\examples{
# load example-problem with suppressions
# (same as example from ?primarySuppression)
p <- sdc_testproblem(with_supps = TRUE)

# which is the overall total?
idx <- which.max(getInfo(p, "freq")); idx

# we see that the cell with idx = 1 is the overall total and its
# anonymization state of the total can be extracted as follows:
print(getInfo(p, type = "sdcStatus")[idx])

# we want this cell to never be suppressed
p <- setInfo(p, type = "sdcStatus", index = idx, input = "z")

# we can verify this:
print(getInfo(p, type = "sdcStatus")[idx])

# changing slot 'UPL' for all cells
inp <- data.frame(
  strID = getInfo(p, "strID"),
  UPL_old = getInfo(p, "UPL")
)
inp$UPL_new <- inp$UPL_old + 1
p <- setInfo(p, type = "UPL", index = 1:nrow(inp), input = inp$UPL_new)
}
\author{
Bernhard Meindl \email{bernhard.meindl@statistik.gv.at}
}
