% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{dWn1D}
\alias{dWn1D}
\title{WN density in 1D}
\usage{
dWn1D(x, mu, sigma, maxK = 2L, expTrc = 30, vmApprox = 0L, kt = 0,
  logConstKt = 0)
}
\arguments{
\item{x}{a vector of length \code{n} containing angles. They all must be in \eqn{[\pi,\pi)} so that the truncated wrapping by \code{maxK} windings is able to capture periodicity.}

\item{mu}{mean parameter. Must be in \eqn{[\pi,\pi)}.}

\item{sigma}{diffusion coefficient.}

\item{maxK}{maximum absolute value of the windings considered in the computation of the WN.}

\item{expTrc}{truncation for exponential: \code{exp(x)} with \code{x <= -expTrc} is set to zero. Defaults to \code{30}.}

\item{vmApprox}{whether to use the von Mises approximation to a wrapped normal (\code{1}) or not (\code{0}, default).}

\item{kt}{concentration for the von Mises, a suitable output from \code{\link{momentMatchWnVm}} (see examples).}

\item{logConstKt}{the logarithm of the von Mises normalizing constant associated to the concentration \code{kt} (see examples)}
}
\value{
A vector of size \code{n} containing the density evaluated at \code{x}.
}
\description{
Computation of the WN density in 1D.
}
\examples{
mu <- 0
sigma <- 1
dWn1D(x = seq(-pi, pi, l = 10), mu = mu, sigma = sigma, vmApprox = 0)

# von Mises approximation
kt <- scoreMatchWnVm(sigma2 = sigma^2)
dWn1D(x = seq(-pi, pi, l = 10), mu = mu, sigma = sigma, vmApprox = 1, kt = kt,
      logConstKt = -log(2 * pi * besselI(x = kt, nu = 0, expon.scaled = TRUE)))
}
