% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{rStatWn2D}
\alias{rStatWn2D}
\title{Simulation from the stationary density of a WN diffusion in 2D}
\usage{
rStatWn2D(n, mu, alpha, sigma, rho = 0)
}
\arguments{
\item{n}{sample size.}

\item{mu}{a vector of length \code{2} giving the mean.}

\item{alpha}{vector of length \code{3} parametrizing the \code{A} matrix as in \code{\link{alphaToA}}.}

\item{sigma}{vector of length \code{2} containing the \strong{square root} of the diagonal of \eqn{\Sigma}, the diffusion matrix.}

\item{rho}{correlation coefficient of \eqn{\Sigma}.}
}
\value{
A matrix of dimension \code{c(n, 2)} containing the samples from the stationary distribution.
}
\description{
Simulates from the stationary density of the WN diffusion in 2D.
}
\examples{
set.seed(345567)
alpha <- c(2, 1, -1)
sigma <- c(1.5, 2)
Sigma <- diag(sigma^2)
A <- alphaToA(alpha = alpha, sigma = sigma)
mu <- c(pi, pi)
plot(rStatWn2D(n = 1000, mu = mu, alpha = alpha, sigma = sigma))
points(toPiInt(mvtnorm::rmvnorm(n = 1000, mean = mu,
                                sigma = solve(A) \%*\% Sigma / 2,
                                method = "chol")), col = 2)
}
