% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{dTpdWou1D}
\alias{dTpdWou1D}
\title{Approximation of the transition probability density of the WN diffusion in 1D}
\usage{
dTpdWou1D(x, x0, t, alpha, mu, sigma, maxK = 2L, expTrc = 30,
  vmApprox = 0L, kt = 0, logConstKt = 0)
}
\arguments{
\item{x}{a vector of length \code{n} containing angles. They all must be in \eqn{[\pi,\pi)} so that the truncated wrapping by \code{maxK} windings is able to capture periodicity.}

\item{x0}{a vector of length \code{n} containing the starting angles. They all must be in \eqn{[\pi,\pi)}.}

\item{t}{a scalar containing the times separating \code{x} and \code{x0}.}

\item{alpha}{drift parameter.}

\item{mu}{mean parameter. Must be in \eqn{[\pi,\pi)}.}

\item{sigma}{diffusion coefficient.}

\item{maxK}{maximum absolute value of the windings considered in the computation of the WN.}

\item{expTrc}{truncation for exponential: \code{exp(x)} with \code{x <= -expTrc} is set to zero. Defaults to \code{30}.}

\item{vmApprox}{whether to use the von Mises approximation to a wrapped normal (\code{1}) or not (\code{0}, default).}

\item{kt}{concentration for the von Mises, a suitable output from \code{\link{momentMatchWnVm}} (see examples).}

\item{logConstKt}{the logarithm of the von Mises normalizing constant associated to the concentration \code{kt} (see examples)}
}
\value{
A vector of size \code{n} containing the tpd evaluated at \code{x}.
}
\description{
Computation of the transition probability density (tpd) for a WN diffusion.
}
\details{
See Section 3.3 in García-Portugués et al. (2019) for details. See \code{\link{dTpdWou}} for the general case (less efficient for 2D).
}
\examples{
t <- 0.5
alpha <- 1
mu <- 0
sigma <- 1
x0 <- 0.1
dTpdWou1D(x = seq(-pi, pi, l = 10), x0 = rep(x0, 10), t = t, alpha = alpha,
          mu = mu, sigma = sigma, vmApprox = 0)

# von Mises approximation
kt <- scoreMatchWnVm(sigma2 = sigma^2 * (1 - exp(-2 * alpha * t)) / (2 * alpha))
dTpdWou1D(x = seq(-pi, pi, l = 10), x0 = rep(x0, 10), t = t, alpha = alpha,
          mu = mu, sigma = sigma, vmApprox = 1, kt = kt,
          logConstKt = -log(2 * pi * besselI(x = kt, nu = 0,
                                             expon.scaled = TRUE)))
}
\references{
García-Portugués, E., Sørensen, M., Mardia, K. V. and Hamelryck, T. (2019) Langevin diffusions on the torus: estimation and applications. \emph{Statistics and Computing}, 29(2):1--22. \doi{10.1007/s11222-017-9790-2}
}
