% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary.R
\name{unwrapCircSeries}
\alias{unwrapCircSeries}
\title{Unwrapping of circular time series}
\usage{
unwrapCircSeries(x)
}
\arguments{
\item{x}{wrapped angles. Must be a vector or a matrix, see details.}
}
\value{
A vector or matrix containing a choice of unwrapped angles of \code{x} that maximizes linear continuity.
}
\description{
Completes a circular time series to a linear one by computing the closest wind numbers. Useful for plotting circular trajectories with crossing of boundaries.
}
\details{
If \code{x} is a matrix then the unwrapping is carried out row-wise, on each column separately.
}
\examples{
# Vectors
x <- c(-pi, -pi/2, pi - 0.1, -pi + 0.2)
u <- unwrapCircSeries(x)
max(abs(toPiInt(u) - x))
plot(toPiInt(x), ylim = c(-pi, pi))
for(k in -1:1) lines(u + 2 * k * pi)

# Matrices
N <- 100
set.seed(234567)
x <- t(euler2D(x0 = rbind(c(0, 0)), A = diag(c(1, 1)), sigma = rep(1, 2),
                 mu = c(pi, pi), N = N, delta = 1, type = 2)[1, , ])
u <- unwrapCircSeries(x)
max(abs(toPiInt(u) - x))
plot(x, xlim = c(-pi, pi), ylim = c(-pi, pi))
for(k1 in -3:3) for(k2 in -3:3) lines(u[, 1] + 2 * k1 * pi,
                                      u[, 2] + 2 * k2 * pi, col = gray(0.5))
}
