% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bn_inference.R
\name{bn_flag_inference}
\alias{bn_flag_inference}
\title{Bayesian inference for error prediction .}
\usage{
bn_flag_inference(dataset, fit_model)
}
\arguments{
\item{dataset}{A data frame.}

\item{fit_model}{A bn fit model generated by \code{\link[bnlearn:bn.fit]{bn.fit}} or \code{\link{gen_bn_learn}} or \code{\link{gen_bn_elicit}}.}
}
\value{
The output is a data frame inferred error flags.
}
\description{
\code{bn_flag_inference} use the trained Bayesian Network model
to predict the errors that may happen in the dataset.
}
\examples{
adult_with_flag <- add_random_error(adult[1:100,], prob = c(0.97, 0.03), "age_missing")
adult_with_flag <- split_data(adult_with_flag, 70)
bn_learn <- gen_bn_learn(adult_with_flag$training_set, "hc")
syn_error_occurrence <- bn_flag_inference(bn_learn$gen_data, bn_learn$fit_model)
syn_error_occurrence

}
