% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/name.R
\name{gen_firstname}
\alias{gen_firstname}
\title{Randomly generate a firstname.}
\usage{
gen_firstname(country = "uk", gender = NA, birthyear = NA, race = NA)
}
\arguments{
\item{country}{A string variable with a default of 'uk'. It is either
'uk' or 'us'.}

\item{gender}{A string variable either 'male' or 'female'.}

\item{birthyear}{A number from 1996 to 2018. For number smaller than 1996 will assumes
as 1996 and greater than 2018 will assumes aas 2018.}

\item{race}{A number or a string of the ethnicity code:
1 American Indian or Native Alaskan, 2 Asian or Pacific Islander,
3 Black (not Hispanic), 4 Hispanic, 5 White (not Hispanic) and
6 Middle-Eastern, Arabic.}
}
\value{
A name string.
}
\description{
\code{gen_firstname} randomly sample a firstname from the selected database:
    \enumerate{
    \item \code{country} If is 'uk', the function will automatically sample a
    firstname that based on the \code{gender} and \code{birthyear}. The uk
    firstname database was extracted from
    \url{https://www.ons.gov.uk/peoplepopulationandcommunity/birthsdeathsandmarriages/livebirths/bulletins/babynamesenglandandwales/2018/relateddata}
    containing firstnames and their frequencies in England and Wales from 1996 to 2018.
    \item If \code{country} is 'us', the function will automatically sample a
    firstname that based on the \code{gender} and \code{race}. The us
    firstname database was extracted from \code{\link[randomNames:randomNamesData]{randomNamesData}}.
    }
}
\examples{
gen_firstname(country = "uk", gender = "male", birthyear = 2013)
gen_firstname(country = "us", gender = "male", race = 2)
gen_firstname(country = "us", gender = "male", race = 'Hispanic')

}
