\name{add}

\alias{add}
\alias{getmethod}
\alias{getmethodNames}
\alias{add,list,character-method}
\alias{getmethod,character-method}
\alias{getmethodNames,ANY-method}

\title{add a new method to the package}

\description{
This function is an interface to extend the package. A user can define a new method band add it to the package. When the method is successfully added, it can be used together with all existing methods. The names of available methods in the package can be seen using \code{getmethodNames}. It is not limited only to modelling (fitting) methods, but can be a replication method, or one to generate pseudo-absences, etc.

You can get an object of an existing method through getmethod.
}

\usage{
add(x,w,echo,...)

getmethod(x,w,...)

getmethodNames(w,...)

}

\arguments{
  \item{x}{Either a \code{list}, or an object generated by \code{getmethod} function}
  \item{w}{specify which group of methods the new method belongs to. "sdm" (default) can be used for modelling method }
  \item{echo}{logical (default=TRUE), determines whether a message should be printed to report if the adding is successful}
  \item{...}{additional arguments. see details}
  }
\details{
These functions provide flexibility to extend the package by adding new methods. It is also possible to add several instances of an existing method to have, for example, a method with different settings at the same time. Whetevet the new method is, it can also be shared and used by other users.

}

\value{
 getmethod gives an object of an appropriate class depending on \code{w}.
 
 getmethodNames generate a list (if alt=TRUE is provided as additional argument) containing the name of methods and all alternative names (aliases) specified for each method, or a character vector (if alt=FALSE) containing the main names.
}

\references{
Naimi, B., Araujo, M.B. (2016) sdm: a reproducible and extensible R platform for species distribution modelling, Ecography, 39:368-375, DOI: 10.1111/ecog.01881
}

\author{Babak Naimi \email{naimi.b@gmail.com}

\url{http://r-gis.net}

\url{http://biogeoinformatics.org}
}



\examples{
\dontrun{
getmethodNames('sdm')
}
}

\keyword{spatial,species,data}
