% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/families.R
\name{Families}
\alias{Families}
\alias{Beta}
\alias{lognormal}
\alias{gengamma}
\alias{gamma_mix}
\alias{lognormal_mix}
\alias{nbinom2_mix}
\alias{nbinom2}
\alias{nbinom1}
\alias{truncated_nbinom2}
\alias{truncated_nbinom1}
\alias{student}
\alias{tweedie}
\alias{censored_poisson}
\alias{delta_gamma}
\alias{delta_gamma_mix}
\alias{delta_gengamma}
\alias{delta_lognormal}
\alias{delta_lognormal_mix}
\alias{delta_truncated_nbinom2}
\alias{delta_truncated_nbinom1}
\alias{delta_poisson_link_gamma}
\alias{delta_poisson_link_lognormal}
\alias{delta_beta}
\title{Additional families}
\usage{
Beta(link = "logit")

lognormal(link = "log")

gengamma(link = "log")

gamma_mix(link = "log")

lognormal_mix(link = "log")

nbinom2_mix(link = "log")

nbinom2(link = "log")

nbinom1(link = "log")

truncated_nbinom2(link = "log")

truncated_nbinom1(link = "log")

student(link = "identity", df = 3)

tweedie(link = "log")

censored_poisson(link = "log")

delta_gamma(link1, link2 = "log", type = c("standard", "poisson-link"))

delta_gamma_mix(link1 = "logit", link2 = "log")

delta_gengamma(link1, link2 = "log", type = c("standard", "poisson-link"))

delta_lognormal(link1, link2 = "log", type = c("standard", "poisson-link"))

delta_lognormal_mix(link1 = "logit", link2 = "log")

delta_truncated_nbinom2(link1 = "logit", link2 = "log")

delta_truncated_nbinom1(link1 = "logit", link2 = "log")

delta_poisson_link_gamma(link1 = "log", link2 = "log")

delta_poisson_link_lognormal(link1 = "log", link2 = "log")

delta_beta(link1 = "logit", link2 = "logit")
}
\arguments{
\item{link}{Link.}

\item{df}{Student-t degrees of freedom fixed value parameter.}

\item{link1}{Link for first part of delta/hurdle model. Defaults to \code{"logit"}
for \code{type = "standard"} and \code{"log"} for \code{type = "poisson-link"}.}

\item{link2}{Link for second part of delta/hurdle model.}

\item{type}{Delta/hurdle family type. \code{"standard"} for a classic hurdle
model. \code{"poisson-link"} for a Poisson-link delta model (Thorson 2018).}
}
\value{
A list with elements common to standard R family objects including \code{family},
\code{link}, \code{linkfun}, and \code{linkinv}. Delta/hurdle model families also have
elements \code{delta} (logical) and \code{type} (standard vs. Poisson-link).
}
\description{
Additional families compatible with \code{\link[=sdmTMB]{sdmTMB()}}.
}
\details{
\code{delta_poisson_link_gamma()} and \code{delta_poisson_link_lognormal()} have been
deprecated in favour of \code{delta_gamma(type = "poisson-link")} and
\code{delta_lognormal(type = "poisson-link")}.

The \code{gengamma()} family was implemented by J.T. Thorson and uses the Prentice
(1974) parameterization such that the lognormal occurs as the internal
parameter \code{gengamma_Q} (reported in \code{print()} as "Generalized gamma lambda")
approaches 0.

The families ending in \verb{_mix()} are 2-component mixtures where each
distribution has its own mean but a shared scale parameter.
(Thorson et al. 2011). See the model-description vignette for details.
The parameter \code{plogis(log_p_mix)} is the probability of the extreme (larger)
mean and \code{exp(log_ratio_mix) + 1} is the ratio of the larger extreme
mean to the "regular" mean. You can see these parameters in
\code{model$sd_report}.

The \code{nbinom2} negative binomial parameterization is the NB2 where the
variance grows quadratically with the mean (Hilbe 2011).

The \code{nbinom1} negative binomial parameterization lets the variance grow
linearly with the mean (Hilbe 2011).

For \code{student()}, the degrees of freedom parameter is currently not estimated and is fixed at \code{df}.
}
\examples{
Beta(link = "logit")
lognormal(link = "log")
gengamma(link = "log")
gamma_mix(link = "log")
lognormal_mix(link = "log")
nbinom2_mix(link = "log")
nbinom2(link = "log")
nbinom1(link = "log")
truncated_nbinom2(link = "log")
truncated_nbinom1(link = "log")
student(link = "identity")
tweedie(link = "log")
censored_poisson(link = "log")
delta_gamma()
delta_gamma_mix()
delta_gengamma()
delta_lognormal()
delta_lognormal_mix()
delta_truncated_nbinom2()
delta_truncated_nbinom1()
delta_beta()
}
\references{
\emph{Generalized gamma family}:

Prentice, R.L. 1974. A log gamma model and its maximum likelihood estimation.
Biometrika 61(3): 539–544. \doi{10.1093/biomet/61.3.539}

Stacy, E.W. 1962. A Generalization of the Gamma Distribution. The Annals of
Mathematical Statistics 33(3): 1187–1192. Institute of Mathematical
Statistics.

\emph{Families ending in \verb{_mix()}}:

Thorson, J.T., Stewart, I.J., and Punt, A.E. 2011. Accounting for fish shoals
in single- and multi-species survey data using mixture distribution models.
Can. J. Fish. Aquat. Sci. 68(9): 1681–1693. \doi{10.1139/f2011-086}.

\emph{Negative binomial families}:

Hilbe, J. M. 2011. Negative binomial regression. Cambridge University Press.

\emph{Poisson-link delta families}:

Thorson, J.T. 2018. Three problems with the conventional delta-model for
biomass sampling data, and a computationally efficient alternative. Canadian
Journal of Fisheries and Aquatic Sciences, 75(9), 1369-1382.
\doi{10.1139/cjfas-2017-0266}
}
\keyword{internal}
