/*
 * Decompiled with CFR 0.152.
 */
package wilx.math.exponential.integrals;

public class ExponentialIntegrals {
    static final double DBL_EPSILON = Math.ulp(1.0);
    static final double epsilon = 10.0 * DBL_EPSILON;
    static final double DBL_MAX = Double.MAX_VALUE;
    static final double[] ei = new double[]{191.5047433355014, 440.3798995348383, 1037.8782907170896, 2492.2289762418777, 6071.406374098611, 14959.532666397528, 37197.688490689034, 93192.51363396537, 234955.8524907683, 595560.998670837, 1516637.8940425168, 3877904.3305974435, 9950907.251046846, 2.5615652664056588E7, 6.612718635548492E7, 1.7114467130036366E8, 4.4396636983027124E8, 1.1541153918491828E9, 3.0059509065255485E9, 7.842940991898187E9, 2.0496497119880814E10, 5.36451185923147E10, 1.405991957584069E11, 3.689732094072742E11, 9.694555759683939E11, 2.550043566357787E12, 6.714640184076498E12, 1.769803724411627E13, 4.669055014466159E13, 1.2328520799120977E14, 3.257988998672264E14, 8.616388199965786E14, 2.2804462003019025E15, 6.039718263611242E15, 1.6006649143245042E16, 4.2447960921368504E16, 1.1263482901669667E17, 2.9904447186323366E17, 7.943916035704454E17, 2.1113423886478241E18, 5.614329680810343E18, 1.4936302131129932E19, 3.975442747903745E19, 1.058563689713169E20};

    public static double Exponential_Integral_Ei(double d) {
        if (d < -5.0) {
            return ExponentialIntegrals.Continued_Fraction_Ei(d);
        }
        if (d == 0.0) {
            return -1.7976931348623157E308;
        }
        if (d < 6.8) {
            return ExponentialIntegrals.Power_Series_Ei(d);
        }
        if (d < 50.0) {
            return ExponentialIntegrals.Argument_Addition_Series_Ei(d);
        }
        return ExponentialIntegrals.Continued_Fraction_Ei(d);
    }

    private static double Continued_Fraction_Ei(double d) {
        double d2 = 1.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 1.0;
        double d6 = ExponentialIntegrals.expl(d);
        double d7 = -d + 1.0;
        double d8 = d7 * d3 + d6 * d2;
        double d9 = d7 * d5 + d6 * d4;
        int n = 1;
        d6 = 1.0;
        while (ExponentialIntegrals.fabsl(d8 * d5 - d3 * d9) > epsilon * ExponentialIntegrals.fabsl(d3 * d9)) {
            if (ExponentialIntegrals.fabsl(d9) > 1.0) {
                d2 = d3 / d9;
                d3 = d8 / d9;
                d4 = d5 / d9;
                d5 = 1.0;
            } else {
                d2 = d3;
                d3 = d8;
                d4 = d5;
                d5 = d9;
            }
            d6 = -n * n;
            d8 = (d7 += 2.0) * d3 + d6 * d2;
            d9 = d7 * d5 + d6 * d4;
            ++n;
        }
        return -d8 / d9;
    }

    private static double Power_Series_Ei(double d) {
        double d2 = -d;
        double d3 = -d;
        double d4 = 0.0;
        double d5 = 1.0;
        double d6 = 1.0;
        double d7 = 1.0;
        if (d == 0.0) {
            return -1.7976931348623157E308;
        }
        while (ExponentialIntegrals.fabsl(d3 - d4) > epsilon * ExponentialIntegrals.fabsl(d4)) {
            d4 = d3;
            d3 += (d5 += 1.0 / d6) * (d2 *= -d) / (d7 *= (d6 += 1.0));
        }
        return 0.5772156649015329 + ExponentialIntegrals.logl(ExponentialIntegrals.fabsl(d)) - ExponentialIntegrals.expl(d) * d3;
    }

    private static double expl(double d) {
        return Math.exp(d);
    }

    private static double fabsl(double d) {
        return Math.abs(d);
    }

    private static double logl(double d) {
        return Math.log(d);
    }

    private static double Argument_Addition_Series_Ei(double d) {
        int n = (int)(d + 0.5);
        int n2 = 0;
        double d2 = n;
        double d3 = d - d2;
        double d4 = d2;
        double d5 = ExponentialIntegrals.expl(d3);
        double d6 = 1.0;
        double d7 = (d5 - 1.0) / d4;
        double d8 = Double.MAX_VALUE;
        double d9 = 1.0;
        double d10 = 1.0;
        while (ExponentialIntegrals.fabsl(d8) > epsilon * ExponentialIntegrals.fabsl(d7)) {
            d8 = d9 * (d5 * (d6 += (d10 *= -d3) / (d9 *= (double)(++n2))) - 1.0) / (d4 *= d2);
            d7 += d8;
        }
        return ei[n - 7] + d7 * ExponentialIntegrals.expl(d2);
    }
}

