% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svec.R
\name{svec}
\alias{svec}
\title{Upper Triangular Vectorization}
\usage{
svec(blk, M, isspx = NULL)
}
\arguments{
\item{blk}{1x2 matrix detailing the type of matrix ("s", "q", "l", "p"), and the size of the matrix}

\item{M}{matrix which is to be vectorized}

\item{isspx}{if M is sparse, isspx = 1, 0 otherwise. Default is to assume M is dense.}
}
\value{
\item{x}{vector of upper triangular components of x}
}
\description{
\code{svec} takes the upper triangular matrix (including the diagonal) and vectorizes
it column-wise.
}
\examples{

data(Hnearcorr)
blk <- matrix(list(),1,2)
blk[[1]] <- "s"
blk[[2]] <- nrow(Hnearcorr)

svec(blk,Hnearcorr)

}

