% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sqlp.R
\name{sqlp}
\alias{sqlp}
\title{Semidefinite Quadratic Linear Programming Solver}
\usage{
sqlp(blk = NULL, At = NULL, C = NULL, b = NULL, control = NULL,
  X0 = NULL, y0 = NULL, Z0 = NULL)
}
\arguments{
\item{blk}{A named-list object describing the block diagonal structure of the SQLP data}

\item{At}{A list object containing constraint matrices for the primal-dual problem}

\item{C}{A list object containing the constant $c$ matrices in the primal objective function}

\item{b}{A vector containing the right hand side of the equality constraints in the primal problem}

\item{control}{A list object specifying the values of certain parameters. If not provided, default values are used}

\item{X0}{An initial iterate for the primal solution variable X. If not provided, an initial iterate is computed internally.}

\item{y0}{An initial iterate for the dual solution variable y. If not provided, an initial iterate is computed internally.}

\item{Z0}{An initial iterate for the dual solution variable Z. If not provided, an initial iterate is computed internally.}
}
\value{
\item{X}{A list containing the solution matrix to the primal problem}
\item{y}{The  solution vector to the dual problem}
\item{Z}{A list containing the  solution matrix to the dual problem}
\item{pobj}{The achieved value of the primary objective function}
\item{dobj}{The achieved value of the dual objective function}
}
\description{
\code{sqlp} solves a semidefinite quadratic linear programming problem using the SDPT3 algorithm of Toh et. al. (1999)
returning both the primal solution X and dual solution Z.
}
\details{
A full mathematical description of the problem to be solved, details surrounding the
input variables, and discussion regarding the output variables can be found in the accompanying vignette.
}
\examples{

blk = c("l" = 2)
C = matrix(c(1,1),nrow=1)
A = matrix(c(1,3,4,-1), nrow=2)
At = t(A)
b = c(12,10)
out = sqlp(blk,list(At),list(C),b)

}
\references{
K.C. Toh, M.J. Todd, and R.H. Tutuncu, SDPT3 --- a Matlab software package for semidefinite programming, Optimization Methods and Software, 11 (1999), pp. 545--581.
R.H Tutuncu, K.C. Toh, and M.J. Todd, Solving semidefinite-quadratic-linear programs using SDPT3, Mathematical Programming Ser. B, 95 (2003), pp. 189--217.
}
