% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oxygen_isotope_seasonality.r
\name{oxygen_isotope_seasonality}
\alias{oxygen_isotope_seasonality}
\title{Function for oxygen isotope based seasonality reconstructions.}
\usage{
oxygen_isotope_seasonality(
  d18Oc,
  ages,
  SD_d18Oc = 0.1,
  d18Ow = 0,
  d18O_fun = "KimONeil97",
  export = FALSE
)
}
\arguments{
\item{d18Oc}{Vector containing subannually resolved
\eqn{\delta^{18}O_{c}}{δ18Oc} data}

\item{ages}{Vector containing ages for of all samples in years relative to
the shell chronology}

\item{SD_d18Oc}{Error on the \eqn{\delta^{18}O_{c}}{δ18Oc} measurements.
Either a single value (constant uncertainty) or a vector of length equal to
the period in SST data (365 days by default) containing information about the
error of each datapoint (1 standard deviation; default = 0.1 permille).}

\item{d18Ow}{Vector containing \eqn{\delta^{18}O}{δ18O} values (in permille
VSMOW) of the precipitation fluid used to calculate temperatures. If only a
single value is provided, the \eqn{\delta^{18}O}{δ18O} of the fluid is
presumed constant at this value. Default = 0 permille VSMOW.}

\item{d18O_fun}{String containing the name of the transfer function used to
convert temperature and \eqn{\delta^{18}O_{w}}{δ18Ow} to
\eqn{\delta^{18}O_{c}}{δ18Oc} data (for example: \code{"KimONeil97"} or
\code{"GrossmanKu86"}). Defaults to Kim and O'Neil (1997).}

\item{export}{Export table summary of result (CSV format)? \code{TRUE/FALSE}}
}
\value{
A data frame containing monthly reconstructions of temperature,
\eqn{\delta^{18}O}{δ18O} of the precipitation fluid and
\eqn{\delta^{18}O_{c}}{δ18Oc}.
}
\description{
Uses records of stable oxygen isotope ratios (\eqn{\delta^{18}O_{c}}{δ18Oc})
through subannually resolved carbonate archives (e.g. mollusk shells or
corals) to reconstruct monthly variability in temperature and salinity
(assuming user provided variability in \eqn{\delta^{18}O}{δ18O} composition of
the precipitation fluid).
}
\examples{
# find attached dummy data
Case1 <- seasonalclumped::Case1
d18Oc <- Case1[, 29]
d18Oc <- d18Oc[-which(is.na(d18Oc))]
ages <- Case1[, 27]
ages <- ages[-which(is.na(ages))]
# Run function
monthly <- oxygen_isotope_seasonality(d18Oc,
ages,
0.1,
0,
"KimONeil97",
FALSE)
}
\references{
Grossman, E.L., Ku, T., Oxygen and carbon isotope fractionation
in biogenic aragonite: temperature effects, \emph{Chemical Geology} \strong{1986},
\emph{59.1}, 59–74.
\url{https://doi.org/bvpzws}

Kim, S., O'Niel, J.R., Equilibrium and nonequilibrium oxygen
isotope effects in synthetic carbonates, \emph{Geochimica et Cosmochimica Acta}
\strong{1997}, \emph{61.16}, 3461–3475.
\url{https://doi.org/c7bwbp}

Dettman, D.L., Reische, A.K., Lohmann, K.C., Controls on the stable isotope
composition of seasonal growth bands in aragonitic fresh–water bivalves
(Unionidae), \emph{Geochimica et Cosmochimica Acta} \strong{1999}, \emph{63.7–8}, 1049–1057.
\url{https://doi.org/cbb7zc}

Brand, W.A., Coplen, T.B., Vogl, J., Rosner, M., Prohaska, T., Assessment of
international reference materials for isotope–ratio analysis (IUPAC Technical
Report), \emph{Pure and Applied Chemistry} \strong{2014}, \emph{86.3}, 425–467.
\url{https://doi.org/fpc2}

de Winter, N. J., Agterhuis, T., Ziegler, M., Optimizing sampling strategies
in high–resolution paleoclimate records, \emph{Climate of the Past Discussions}
\strong{2020}, 1–52.
\url{https://doi.org/fpc4}
}
