\name{Fletcher.chat}

\alias{Fletcher.chat}

\title{Estimate overdispersion}

\description{ 

General function for estimating a variance inflation factor (\eqn{\hat c}) from observed counts.

}

\usage{

Fletcher.chat (observed, expected, np, verbose = TRUE, 
    type = c('Fletcher', 'Wedderburn', 'both'), multinomial = FALSE)

}

\arguments{

  \item{observed}{integer vector of observed counts, or a list of such vectors}
  \item{expected}{numeric vector of expected counts}
  \item{np}{integer number of parameters estimated}
  \item{verbose}{logical; if TRUE returns extended output}
  \item{type}{character}
  \item{multinomial}{logical; if TRUE, one df is subtracted for the constraint}

}

\details{

\code{Fletcher.chat} applies the overdispersion formula of Fletcher (2012) or computes the conventional (Wedderburn 1974) variance inflation factor \eqn{X^2/df}. It is used by \code{\link{chat.nk}} and \code{\link{adjustVarD}}. The inputs `observed' and `expected' are vectors of counts (e.g., number of distinct individuals per detector); `observed' may also be a list of such vectors, possibly simulated.

  }

\value{

Output depends on `verbose', `observed' and `type':

-- if `observed' is a list of nk vectors (usually generated by simulation) then the output is a vector of (Fletcher or Wedderburn) \eqn{\hat c} values, one element for each component of `observed', unless type = "both" when the output is a list of two such vectors. Argument `verbose' is ignored.

-- if `observed' is a simple vector then `verbose' output is a list comprising input values, various summary statistics, and the computed Fletcher overdispersion (`chat'). The statistic `cX2' is the conventional variance inflation factor of Wedderburn (1974) -- \eqn{X^2/df}. For \code{verbose = FALSE}, a single estimate of \eqn{\hat c} is returned when \code{type = "Fletcher"} or \code{type = "Wedderburn"}, otherwise a vector of the two estimates.

}

\seealso{

\code{\link{chat.nk}},
\code{\link{adjustVarD}}

}

\references{

Fletcher, D. (2012) Estimating overdispersion when fitting a generalized linear model to sparse data.
\emph{Biometrika} \bold{99}, 230--237.

Wedderburn, R. W. M. (1974) Quasi-likelihood functions, generalized linear models, and the Gauss-Newton
method. \emph{Biometrika} \bold{61}, 439--47.

}
