% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assess_form_variable_completeness.R
\name{assess_form_variable_completeness}
\alias{assess_form_variable_completeness}
\title{Asses completeness of data for each variable in a secuTrial export}
\usage{
assess_form_variable_completeness(
  form,
  casenodes_table,
  validation_overview,
  completeness = "allforms",
  occ_in_vp = 1,
  omit_mnp = TRUE
)
}
\arguments{
\item{form}{data.frame Form for which to assess variable completeness
(i.e. a list element returned by read_secuTrial_raw).}

\item{casenodes_table}{data.frame The central casenodes record file
(i.e. 'casenodes' from the list returned by read_secuTrial_raw).}

\item{validation_overview}{tibble returned by read_validation_overview.}

\item{completeness}{string Specifies if completeness is assessed for all forms ('allforms')
or only for saved forms ('savedforms').}

\item{occ_in_vp}{integer Specifies how often the form occurs in the visit plan
(only relevant if completeness = 'allforms' is set).}

\item{omit_mnp}{boolean Removes variable names from the result table that start with mnp.}
}
\value{
data.frame showing percent completeness per variable.
}
\description{
NOTE: This is not exported currently since it is not generic enough.
      It can still be used but in depth knowledge of the function is required
      to evaluate if the result is correct.
      As a rule of thumb: rigid CDMA setups with low complexity will likely
                          work as expected.

Variable completeness is defined as percentage of data entered for a variable
when considering all occurrences of the variable throughout the visit plan and
all participants registered in the secuTrial data base. The completeness can
be assessed for 'allforms', which will also take unsaved forms into account, and
for 'savedforms' which will only consider forms that have been actively saved.
In order to asses variable completeness the function requires a loaded secuTrial
validation overview and a loaded secuTrial standard export. Both the validation
overview and the data export should be from the same time (not more than minutes
apart if possible) to ensure data integrity.
Variable completeness is considered based on rules in the secuTrial setup. Thus,
if a variable is not marked as necessary for completeness, this variable will
always be considered as 100 percent complete if only 'savedforms' are assessed.
Please note that variable completeness for repetition forms should only be
assessed for saved forms.
}
\examples{
# prepare path to example export
export_location <- system.file("extdata", "sT_exports", "BMD",
                               "s_export_CSV-xls_BMD_short_en_utf8.zip",
                               package = "secuTrialR")
# read all export data
sT_export <- read_secuTrial_raw(data_dir = export_location)

# read validation overview
val_ovv_location <- system.file("extdata", "sT_exports", "BMD",
                                "bmd_validation_overview.xlsx",
                                package = "secuTrialR")
val_ovv <- read_validation_overview(data_dir = val_ovv_location)

secuTrialR:::assess_form_variable_completeness(form = sT_export$bmd,
                                               casenodes_table = sT_export$cn,
                                               validation_overview = val_ovv,
                                               completeness = "allforms",
                                               occ_in_vp = 5)

}
\seealso{
read_validation_overview, read_secuTrial_raw
}
