% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coord_radar.R
\name{coord_radar}
\alias{coord_radar}
\title{Radar coordinate system}
\usage{
coord_radar(theta = "x", start = 0, direction = 1)
}
\arguments{
\item{theta}{Can be 'x' or 'y'.}

\item{start}{Starting position. Best expressed in terms of \code{pi} (e.g., \code{-pi/4}).}

\item{direction}{The direction of plotting. Can be 1 or -1.}
}
\description{
Add a radar coordinate system useful for radar charts.
}
\examples{
# Create a radar/spider chart with ggplot:
library(dplyr)
library(tidyr)
library(ggplot2)

data <- iris \%>\%
  group_by(Species) \%>\%
  summarise_all(mean) \%>\%
  pivot_longer(-Species)

data \%>\%
  ggplot(aes(x = name, y = value, color = Species, group = Species)) +
  geom_polygon(fill = NA, size = 2) +
  coord_radar(start = -pi/4)

}
