% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.bayesfactor_models.R
\name{plot.see_bayesfactor_models}
\alias{plot.see_bayesfactor_models}
\title{Plot method for Bayes Factors for model comparison}
\usage{
\method{plot}{see_bayesfactor_models}(
  x,
  n_pies = c("one", "many"),
  value = c("none", "BF", "probability"),
  sort = FALSE,
  log = FALSE,
  prior_odds = NULL,
  ...
)
}
\arguments{
\item{x}{An object.}

\item{n_pies}{Number of pies.}

\item{value}{What value to display.}

\item{sort}{\describe{
  \item{\emph{Plotting model parameters}}{
  If \code{NULL}, coefficients are plotted in the order as they appear in the summary. Use \code{sort = "ascending"} (or \code{sort = TRUE})) resp. \code{sort = "descending"} to sort coefficients in ascending or descending order.
  }
  \item{\emph{Plotting Bayes factors}}{
  Sort pie-slices by posterior probability (descending)?
  }
}}

\item{log}{Show log-transformed Bayes factors.}

\item{prior_odds}{optional vector of prior odds for the models. See
\code{BayesFactor::priorOdds}. As the size of the pizza slices corresponds
to posterior probability (which is a function of prior probability and the BF),
custom \code{prior_odds} will change the slices' size.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A ggplot2-object.
}
\description{
The \code{plot()} method for the \code{bayestestR::bayesfactor_models()} function.
These plots visualize the \strong{posterior probabilities} of the compared models.
}
\examples{
library(bayestestR)
library(see)

lm0 <- lm(qsec ~ 1, data = mtcars)
lm1 <- lm(qsec ~ drat, data = mtcars)
lm2 <- lm(qsec ~ wt, data = mtcars)
lm3 <- lm(qsec ~ drat + wt, data = mtcars)

result <- bayesfactor_models(lm1, lm2, lm3, denominator = lm0)

plot(result, n_pies = "one", value = "probability", sort = TRUE) +
  scale_fill_pizza(reverse = TRUE)

plot(result, n_pies = "many", value = "BF", log = TRUE) +
  scale_fill_pizza(reverse = FALSE)
}
