% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.performance_pp_check.R
\name{print.see_performance_pp_check}
\alias{print.see_performance_pp_check}
\alias{plot.see_performance_pp_check}
\title{Plot method for posterior predictive checks}
\usage{
\method{print}{see_performance_pp_check}(x, size_line = 0.7, line_alpha = 0.25, size_bar = 0.7, ...)

\method{plot}{see_performance_pp_check}(x, size_line = 0.7, line_alpha = 0.25, size_bar = 0.7, ...)
}
\arguments{
\item{x}{An object.}

\item{size_line}{Size of line geoms.}

\item{line_alpha}{Alpha value of lines indicating \code{yrep}.}

\item{size_bar}{Size of bar geoms.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A ggplot2-object.
}
\description{
The \code{plot()} method for the \code{performance::pp_check()} function.
}
\examples{
if (require("performance")) {
  model <- lm(Sepal.Length ~ Species * Petal.Width + Petal.Length, data = iris)
  pp_check(model)
}
}
