% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.hdi.R
\name{plot.see_hdi}
\alias{plot.see_hdi}
\title{Plot method for uncertainty or credible intervals}
\usage{
\method{plot}{see_hdi}(
  x,
  data = NULL,
  show_intercept = FALSE,
  show_zero = TRUE,
  show_title = TRUE,
  n_columns = 1,
  ...
)
}
\arguments{
\item{x}{An object.}

\item{data}{The original data used to create this object. Can be a
statistical model.}

\item{show_intercept}{Logical, if \code{TRUE}, the intercept-parameter is included
in the plot. By default, it is hidden because in many cases the
intercept-parameter has a posterior distribution on a very different
location, so density curves of posterior distributions for other parameters
are hardly visible.}

\item{show_zero}{Logical. If \code{TRUE}, will add a vertical (dotted) line
at 0.}

\item{show_title}{Logical. If \code{TRUE}, will show the title of the plot.}

\item{n_columns}{For models with multiple components (like fixed and random,
count and zero-inflated), defines the number of columns for the
panel-layout. If \code{NULL}, a single, integrated plot is shown.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A ggplot2-object.
}
\description{
The \code{plot()} method for the \code{bayestestR::hdi()} and related
function.
}
\examples{
\dontshow{if (identical(Sys.getenv("NOT_CRAN"), "true") && require("rstanarm")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(rstanarm)
library(bayestestR)
set.seed(123)
m <<- suppressWarnings(stan_glm(Sepal.Length ~ Petal.Width * Species, data = iris, refresh = 0))
result <- hdi(m)
result
plot(result)
\dontshow{\}) # examplesIf}
}
