% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.parameters_brms_meta.R
\name{plot.see_parameters_brms_meta}
\alias{plot.see_parameters_brms_meta}
\title{Plot method for Model Parameters from Bayesian Meta-Analysis}
\usage{
\method{plot}{see_parameters_brms_meta}(
  x,
  size_point = 2,
  size_line = 0.8,
  size_text = 3.5,
  posteriors_alpha = 0.7,
  rope_alpha = 0.15,
  rope_color = "cadetblue",
  normalize_height = TRUE,
  show_labels = TRUE,
  ...
)
}
\arguments{
\item{x}{An object.}

\item{size_point}{Numeric specifying size of point-geoms.}

\item{size_line}{Numeric value specifying size of line geoms.}

\item{size_text}{Numeric value specifying size of text labels.}

\item{posteriors_alpha}{Numeric value specifying alpha for the posterior
distributions.}

\item{rope_alpha}{Numeric specifying transparency level of ROPE ribbon.}

\item{rope_color}{Character specifying color of ROPE ribbon.}

\item{normalize_height}{Logical. If \code{TRUE}, height of mcmc-areas is
"normalized", to avoid overlap. In certain cases when the range of a
posterior distribution is narrow for some parameters, this may result in
very flat mcmc-areas. In such cases, set \code{normalize_height = FALSE}.}

\item{show_labels}{Logical. If \code{TRUE}, text labels are displayed.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A ggplot2-object.
}
\description{
The \code{plot()} method for the \code{parameters::model_parameters()}
function when used with brms-meta-analysis models.
}
\details{
\subsection{Colors of density areas and errorbars}{
To change the colors of the density areas, use \code{scale_fill_manual()}
with named color-values, e.g. \code{scale_fill_manual(values = c("Study" = "blue", "Overall" = "green"))}.
To change the color of the error bars, use \code{scale_color_manual(values = c("Errorbar" = "red"))}.
}
\subsection{Show or hide estimates and CI}{
Use \code{show_labels = FALSE} to hide the textual
output of estimates and credible intervals.
}
}
\examples{
\dontshow{if (require("brms") && require("metafor") && require("RcppEigen") && require("BH")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
library(parameters)
library(brms)
library(metafor)
data(dat.bcg)

dat <- escalc(
  measure = "RR",
  ai = tpos,
  bi = tneg,
  ci = cpos,
  di = cneg,
  data = dat.bcg
)
dat$author <- make.unique(dat$author)

# model
set.seed(123)
priors <- c(
  prior(normal(0, 1), class = Intercept),
  prior(cauchy(0, 0.5), class = sd)
)
model <- suppressWarnings(
  brm(yi | se(vi) ~ 1 + (1 | author), data = dat, refresh = 0, silent = 2)
)

# result
mp <- model_parameters(model)
plot(mp)
}
\dontshow{\}) # examplesIf}
}
