% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter-files.R
\name{has_null_bytes}
\alias{has_null_bytes}
\title{Detect Null Bytes in a File}
\usage{
has_null_bytes(file, n = 1000L)
}
\arguments{
\item{file}{A character string representing a single file path.}

\item{n}{The number of bytes to read for binary detection in files with unknown extensions. Defaults to 1000.}
}
\value{
\code{TRUE} if a null byte is found or if an error occurs. \code{FALSE} otherwise.
}
\description{
Reads the first \code{n} bytes of a file and checks whether any null bytes (\code{0x00})
are present, which is commonly used to detect binary files.

If the file cannot be read (e.g., corrupted or permission issues), the function
safely assumes the file is binary and returns \code{TRUE}.
}
\keyword{internal}
