% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_actual_element.R
\name{get_actual_element}
\alias{get_actual_element}
\alias{get_actual_elements}
\title{Get the element associated with a selenider element}
\usage{
get_actual_element(x, timeout = NULL)

get_actual_elements(x, timeout = NULL)
}
\arguments{
\item{x}{A \code{selenider_element} or \code{selenider_elements} object, produced by
\code{\link[=find_element]{find_element()}} / \code{\link[=find_elements]{find_elements()}}.}

\item{timeout}{The timeout to use while asserting that the item exists. If
NULL, the timeout of the \code{selenider_element} will be used.}
}
\value{
An integer (backendNodeId), or a \link[selenium:WebElement]{selenium::WebElement} object.
\code{get_actual_elements()} returns a list of such objects.
}
\description{
Turn a lazy selenium element or element collection into a backendNodeId
(chromote) or a \link[selenium:WebElement]{selenium::WebElement}. Use this to perform certain actions
on the element that are not implemented in selenider.

\code{get_actual_element()} turns a \code{selenider_element} object into a single
backendNodeId or \link[selenium:WebElement]{selenium::WebElement} object. The function will wait for
the object to exist in the DOM.

\code{get_actual_elements()} turns a \code{selenider_elements} object into a list
of \link[selenium:WebElement]{selenium::WebElement} objects, waiting for any parent objects to
exist in the DOM.
}
\examples{
\dontshow{if (selenider::selenider_available(online = FALSE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
html <- "
<div>
<p>Text</p>
<p>More text</p>
</div>
"

session <- minimal_selenider_session(html)

elem <- s("div") |>
  get_actual_element()

# The webDriver/ChromoteSession can be accessed using session$driver
driver <- session$driver

if (inherits(driver, "ChromoteSession")) {
  driver$DOM$getBoxModel(backendNodeId = elem)
} else if (inherits(elem, "WebElement")) {
  elem$get_rect()
}

elems <- ss("p") |>
  get_actual_elements()

if (inherits(driver, "ChromoteSession")) {
  driver$DOM$describeNode(backendNodeId = elems[[1]])
} else if (inherits(elems[[1]], "WebElement")) {
  elems[[1]]$get_rect()
}

\dontshow{
# Clean up all connections and invalidate default chromote object
selenider_cleanup()
}
\dontshow{\}) # examplesIf}
}
\seealso{
\itemize{
\item \code{\link[=s]{s()}}, \code{\link[=ss]{ss()}}, \code{\link[=find_element]{find_element()}} and \code{\link[=find_elements]{find_elements()}} to select selenider
elements.
\item \code{\link[=elem_cache]{elem_cache()}} and \code{\link[=elem_cache]{elem_cache()}} to cache these values.
\item The \href{https://chromedevtools.github.io/devtools-protocol/tot/}{Chrome Devtools Protocol documentation}
for the operations that can be performed using a backend node id. Note
that this requires the \link[chromote:ChromoteSession]{chromote::ChromoteSession} object, which can be
retrieved using \verb{<selenider_session>$driver}.
\item The documentation for \code{\link[selenium:WebElement]{selenium::WebElement()}} to see the things you can
do with a webElement.
}
}
