% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/std_coeff_fun.R
\name{xNam}
\alias{xNam}
\title{Get Model Term Names}
\usage{
xNam(mod, data = NULL, intercept = TRUE, aliased = TRUE, list = FALSE, ...)
}
\arguments{
\item{mod}{A fitted model object, or a list or nested list of such objects.}

\item{data}{An optional dataset used to construct the model frame.}

\item{intercept}{Logical, whether the intercept should be included.}

\item{aliased}{Logical, whether names of aliased terms should be included
(see Details).}

\item{list}{Logical, whether names should be returned as a list, with all
multi-coefficient terms grouped under their main term names.}

\item{...}{Arguments to \code{eval} (for evaluating model data).}
}
\value{
A character vector or list/nested list of term names.
}
\description{
Extract term names from a fitted model object.
}
\details{
Extract term names from a fitted model. Names of terms for which
  coefficients cannot be estimated are also included if \code{aliased = TRUE}
  (default). These may be terms which are perfectly correlated with other
  terms in the model, so that the model design matrix is rank deficient.
}
\examples{
## Term names from Shipley SEM
m <- Shipley.SEM
xNam(m)
xNam(m, intercept = FALSE)

## Model with different types of predictor (some multi-coefficient terms)
d <- data.frame(
  y = rnorm(100),
  x1 = poly(rnorm(100), 2),  # polynomial
  x2 = as.factor(rep(c("a", "b", "c", "d"), each = 25)),  # categorical
  x3 = rep(1, 100)  # no variation
)
m <- lm(y ~ x1.1 + x1.2 + x2 + x3, data = d)
xNam(m)
xNam(m, aliased = FALSE)  # drop term that cannot be estimated (x3)
xNam(m, aliased = FALSE, list = TRUE)  # as named list
}
