% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{semPower.powerPlot.byN}
\alias{semPower.powerPlot.byN}
\title{sempower.powerPlot.byN}
\usage{
semPower.powerPlot.byN(effect = NULL, effect.measure = NULL, alpha, df,
  p = NULL, SigmaHat = NULL, Sigma = NULL, power.min = alpha,
  power.max = 0.999, steps = 50, linewidth = 1)
}
\arguments{
\item{effect}{effect size specifying the discrepancy between H0 and H1}

\item{effect.measure}{type of effect, one of "F0", "RMSEA", "Mc", "GFI", AGFI"}

\item{alpha}{alpha error}

\item{df}{the model degrees of freedom}

\item{p}{the number of observed variables, required for effect.measure = "GFI" and "AGFI"}

\item{SigmaHat}{model implied covariance matrix. Use in conjuntion with Sigma to define effect and effect.measure.}

\item{Sigma}{population covariance matrix. Use in conjuntion with SigmaHat to define effect and effect.measure.}

\item{power.min}{minimum power, must not be smaller than alpha}

\item{power.max}{maximum power}

\item{steps}{number of steps}

\item{linewidth}{linewidth}
}
\value{
powerplot
}
\description{
show a plot showing power as function of N for a given effect and alpha
}
\examples{
\dontrun{
semPower.powerPlot.byN(effect = .05, effect.measure = "RMSEA", 
                       alpha = .05, power.min = .05, power.max = .999, df = 200)
}
}
