% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{semPower.powerPlot.byN}
\alias{semPower.powerPlot.byN}
\title{semPower.powerPlot.byN}
\usage{
semPower.powerPlot.byN(
  effect = NULL,
  effect.measure = NULL,
  alpha,
  df,
  p = NULL,
  SigmaHat = NULL,
  Sigma = NULL,
  power.min = alpha,
  power.max = 0.99,
  steps = 50,
  linewidth = 1
)
}
\arguments{
\item{effect}{effect size specifying the discrepancy between H0 and H1}

\item{effect.measure}{type of effect, one of \code{"F0"}, \code{"RMSEA"}, \code{"Mc"}, \code{"GFI"}, \code{"AGFI"}}

\item{alpha}{alpha error}

\item{df}{the model degrees of freedom}

\item{p}{the number of observed variables, required for \code{effect.measure = "GFI"} and \code{effect.measure = "AGFI"}}

\item{SigmaHat}{model implied covariance matrix. Use in conjunction with \verb{Sigma`` to define }effect\code{and}effect.measure`.}

\item{Sigma}{population covariance matrix. Use in conjunction with \code{SigmaHat} to define \code{effect} and \code{effect.measure}.}

\item{power.min}{minimum power, must not be smaller than \code{alpha}.}

\item{power.max}{maximum power}

\item{steps}{number of steps}

\item{linewidth}{linewidth}
}
\value{
powerplot
}
\description{
Shows a plot showing power as function of N for a given effect and alpha.
}
\examples{
\dontrun{
semPower.powerPlot.byN(effect = .05, effect.measure = "RMSEA", 
                       alpha = .05, power.min = .05, power.max = .99, df = 200)
}
}
