% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semantic_dashboard.R
\name{dashboard_sidebar}
\alias{dashboard_sidebar}
\alias{dashboardSidebar}
\title{Create a sidebar of a dashboard.}
\usage{
dashboard_sidebar(
  ...,
  side = "left",
  size = "thin",
  color = "",
  inverted = FALSE,
  closable = FALSE,
  pushable = TRUE,
  center = FALSE,
  visible = TRUE,
  disable = FALSE,
  overlay = FALSE,
  dim_page = FALSE,
  class = ""
)

dashboardSidebar(
  ...,
  side = "left",
  size = "thin",
  color = "",
  inverted = FALSE,
  closable = FALSE,
  pushable = TRUE,
  center = FALSE,
  visible = TRUE,
  disable = FALSE,
  overlay = FALSE,
  dim_page = FALSE,
  class = ""
)
}
\arguments{
\item{...}{UI elements to include within the sidebar.}

\item{side}{Placement of the sidebar. One of \code{c("left", "right", "top", "bottom")}}

\item{size}{Size of the sidebar. One of \code{c("", "thin", "very thin", "wide", "very wide")}}

\item{color}{Color of the sidebar / text / icons (depending on the value of `inverted` parameter. \
One of \code{c("", "red", "orange", "yellow", "olive", "green", "teal", "blue", "violet", "purple", "pink", "brown", "grey", "black")}}

\item{inverted}{If FALSE sidebar will be white and text will be colored. \
If TRUE text will be white and background will be colored. Default is \code{FALSE}.}

\item{closable}{If \code{TRUE} allow close sidebar by clicking in the body. Default to \code{FALSE}}

\item{pushable}{If \code{TRUE} the menu button is active. Default to \code{TRUE}}

\item{center}{Should label and icon be centerd on menu items. Default to \code{FALSE}}

\item{visible}{Should sidebar be visible on start. Default to \code{TRUE}}

\item{disable}{If \code{TRUE}, don't display the sidebar.}

\item{overlay}{If \code{TRUE}, opened sidebar will cover the tab content. Otherwise it is displayed next to the content.
Relevant only for sidebar positioned on left or right. Default to \code{FALSE}}

\item{dim_page}{If \code{TRUE}, page content will be darkened when sidebr is open. Default to \code{FALSE}}

\item{class}{CSS class to be applied to the container of \code{dashboardSidebar}.}
}
\value{
A sidebar that can be passed to \code{\link[semantic.dashboard]{dashboardPage}}
}
\description{
Create a pushable sidebar of a dashboard with menu items and other additional UI elements.
}
\section{Functions}{
\itemize{
\item \code{dashboardSidebar}: Create a sidebar of a dashboard (alias for \code{dashboard_sidebar} for compatibility with \code{shinydashboard})
}}

\examples{
if(interactive()){

  library(shiny)
  library(semantic.dashboard)

  ui <- dashboardPage(
    dashboardHeader(color = "blue"),
    dashboardSidebar(side = "left", size = "thin", color = "teal",
                     sidebarMenu(
                       menuItem(tabName = "tab1", "Tab 1"),
                       menuItem(tabName = "tab2", "Tab 2"))),
    dashboardBody(tabItems(
      tabItem(tabName = "tab1", p("Tab 1")),
      tabItem(tabName = "tab2", p("Tab 2"))))
  )

  server <- function(input, output) {
  }

  shinyApp(ui, server)
}
}
