% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_paths_and_intervals.R
\name{confidence_interval}
\alias{confidence_interval}
\title{seminr confidence intervals function}
\usage{
confidence_interval(boot_seminr_model, from, to, through, alpha)
}
\arguments{
\item{boot_seminr_model}{A bootstrapped model returned by the \code{bootstrap_model} function.}

\item{from}{A parameter specifying the antecedent composite for the path.}

\item{to}{A parameter specifying the outcome composite for the path.}

\item{through}{A parameter to specify the mediator for the path. Default is NULL.}

\item{alpha}{A parameter for specifying the alpha for the confidence interval. Default is 0.05.}
}
\description{
The \code{seminr} package provides a natural syntax for researchers to describe PLS
structural equation models.
\code{confidence_interval} provides the verb for calculating the confidence intervals of a
direct or mediated path in a bootstrapped SEMinR model.
}
\examples{
mobi_mm <- constructs(
composite("Image",        multi_items("IMAG", 1:5)),
composite("Expectation",  multi_items("CUEX", 1:3)),
composite("Quality",      multi_items("PERQ", 1:7)),
composite("Value",        multi_items("PERV", 1:2)),
composite("Satisfaction", multi_items("CUSA", 1:3)),
composite("Complaints",   single_item("CUSCO")),
composite("Loyalty",      multi_items("CUSL", 1:3))
)

# Creating structural model
mobi_sm <- relationships(
  paths(from = "Image",        to = c("Expectation", "Satisfaction", "Loyalty")),
  paths(from = "Expectation",  to = c("Quality", "Value", "Satisfaction")),
  paths(from = "Quality",      to = c("Value", "Satisfaction")),
  paths(from = "Value",        to = c("Satisfaction")),
  paths(from = "Satisfaction", to = c("Complaints", "Loyalty")),
  paths(from = "Complaints",   to = "Loyalty")
)

# Estimating the model
mobi_pls <- estimate_pls(data = mobi,
                         measurement_model = mobi_mm,
                         structural_model = mobi_sm)

# Load data, assemble model, and bootstrap
boot_seminr_model <- bootstrap_model(seminr_model = mobi_pls,
                                     nboot = 50, cores = 2, seed = NULL)

confidence_interval(boot_seminr_model = boot_seminr_model,
                    from = "Image",
                    through = "Expectation",
                    to = "Satisfaction",
                    alpha = 0.05)
}
\references{
Zhao, X., Lynch Jr, J. G., & Chen, Q. (2010). Reconsidering Baron and Kenny: Myths and truths
about mediation analysis. Journal of consumer research, 37(2), 197-206.
}
\seealso{
\code{\link{bootstrap_model}}
}
