% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_sobol.R
\name{plot_sobol}
\alias{plot_sobol}
\title{Plot Sobol' first and total-order indices}
\usage{
plot_sobol(x, dummy = NULL, type = 1)
}
\arguments{
\item{x}{A data.table.}

\item{dummy}{The output of the \code{sobol_ci_dummy} function. If supplied and
\code{type = 1}, the plot includes an horizontal transparent frame showing the confidence
intervals of the first and total-order indices for the dummy parameter.}

\item{type}{An integer. If \code{type = 1}, it plots first and total effects.
If \code{type = 2}, it plots second-order effects. If \code{type = 3}, it plots
third-order effects. Default is \code{type = 1}.}
}
\value{
A ggplot object.
}
\description{
Plot Sobol' first and total-order indices
}
\examples{
# Define settings:
n <- 500; k <- 8; R <- 100
# Design the sample matrix:
A <- sobol_matrices(n = n, k = k, second = TRUE, third = TRUE)
# Compute the model output:
Y <- sobol_Fun(A)
# Compute the Sobol' indices:
\donttest{sens <- sobol_indices(Y = Y, params = colnames(data.frame(A)),
R = R, n = n, parallel = "no", ncpus = 1, second = TRUE, third = TRUE)
# Compute the Sobol' indices for the dummy parameter:
s.dummy <- sobol_dummy(Y = Y, params = colnames(data.frame(A)), R = R, n = n)
# Compute confidence intervals:
sens.ci <- sobol_ci(sens, params = colnames(data.frame(A)), type = "norm", conf = 0.95)
# Compute confidence intervals for the dummy parameter:
s.dummy.ci <- sobol_ci_dummy(s.dummy, type = "norm", conf = 0.95)
# Plot Sobol' indices:
plot_sobol(sens.ci, dummy = s.dummy.ci, type = 1)}
}
