% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_sentences.R
\name{get_sentences}
\alias{get_sentences}
\title{Get Sentences}
\usage{
get_sentences(x, ...)
}
\arguments{
\item{x}{A character vector, \code{sentiment}, or \code{sentiment_by} object.}

\item{\ldots}{Other arguments passed to \code{\link[textshape]{split_sentence}}.}
}
\value{
Returns a list of vectors of sentences.
}
\description{
\code{get_sentences} - Get sentences from a character vector, \code{sentiment}, or
\code{sentiment_by} object.
}
\examples{
dat <- data.frame(
    w = c('Person 1', 'Person 2'),
    x = c(paste0(
        "Mr. Brown comes! He says hello. i give him coffee.  i will ",
        "go at 5 p. m. eastern time.  Or somewhere in between!go there"
    ), "One more thought for the road! I am going now.  Good day."),
    y = state.name[c(32, 38)], 
    z = c(.456, .124),
    stringsAsFactors = FALSE
)
get_sentences(dat$x)
get_sentences(dat)
}
