% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sentiment_by.R
\name{sentiment_by}
\alias{sentiment_by}
\title{Polarity Score (Sentiment Analysis) By Groups}
\usage{
sentiment_by(text.var, by = NULL,
  averaging.function = sentimentr::average_downweighted_zero, group.names,
  ...)
}
\arguments{
\item{text.var}{The text variable.  Also takes a \code{sentimentr} or
\code{sentiment_by} object.}

\item{by}{The grouping variable(s).  Default \code{NULL} uses the original
row/element indices; if you used a column of 12 rows for \code{text.var}
these 12 rows will be used as the grouping variable.  Also takes a single
grouping variable or a list of 1 or more grouping variables.}

\item{averaging.function}{A function for performing the group by averaging.
The default, \code{\link[sentimentr]{average_downweighted_zero}}, downweights 
zero values in the averaging.  Note that the function must handle 
\code{NA}s.  The \pkg{sentimentr} functions 
\code{average_weighted_mixed_sentiment} and \code{average_mean} are also 
available.  The former upweights negative when the analysts suspects the 
speaker is likely to surround negatives with positives (mixed) as a polite 
social convention but still the affective state is negative.  The later is a 
standard mean average.}

\item{group.names}{A vector of names that corresponds to group.  Generally
for internal use.}

\item{\ldots}{Other arguments passed to \code{\link[sentimentr]{sentiment}}.}
}
\value{
Returns a \pkg{data.table} with grouping variables plus:
\itemize{
  \item  element_id - The id number of the original vector passed to \code{sentiment}
  \item  sentence_id - The id number of the sentences within each \code{element_id}
  \item  word_count - Word count \code{\link[base]{sum}}med by grouping variable
  \item  sd - Standard deviation (\code{\link[stats]{sd}}) of the sentiment/polarity score by grouping variable
  \item  ave_sentiment - Sentiment/polarity score \code{\link[base]{mean}} average by grouping variable
}
}
\description{
Approximate the sentiment (polarity) of text by grouping variable(s).  For a
full description of the sentiment detection algorithm see 
\code{\link[sentimentr]{sentiment}}.  See \code{\link[sentimentr]{sentiment}}
for more details about the algorithm, the sentiment/valence shifter keys
that can be passed into the function, and other arguments that can be passed.
}
\examples{
mytext <- c(
   'do you like it?  It is red. But I hate really bad dogs',
   'I am the best friend.',
   "Do you really like it?  I'm not happy"
)

## works on a character vector but not the preferred method avoiding the 
## repeated cost of doing sentence boundary disambiguation every time 
## `sentiment` is run
\dontrun{
sentiment(mytext)
sentiment_by(mytext)
}

## preferred method avoiding paying the cost 
mytext <- get_sentences(mytext)

sentiment_by(mytext)
sentiment_by(mytext, averaging.function = average_mean)
sentiment_by(mytext, averaging.function = average_weighted_mixed_sentiment)
get_sentences(sentiment_by(mytext))

(mysentiment <- sentiment_by(mytext, question.weight = 0))
stats::setNames(get_sentences(sentiment_by(mytext, question.weight = 0)),
    round(mysentiment[["ave_sentiment"]], 3))

pres_dat <- get_sentences(presidential_debates_2012)

\dontrun{
## less optimized way
with(presidential_debates_2012, sentiment_by(dialogue, person))
}

\dontrun{
sentiment_by(pres_dat, 'person')

(out <- sentiment_by(pres_dat, c('person', 'time')))
plot(out)
plot(uncombine(out))

sentiment_by(out, presidential_debates_2012$person)
with(presidential_debates_2012, sentiment_by(out, time))

highlight(with(presidential_debates_2012, sentiment_by(out, list(person, time))))
}

\dontrun{
## tidy approach
library(dplyr)
library(magrittr)

cannon_reviews \%>\%
   mutate(review_split = get_sentences(text)) \%$\%
   sentiment_by(review_split)
}
}
\seealso{
Other sentiment functions: \code{\link{sentiment}}
}
\keyword{group}
\keyword{polarity,}
\keyword{sentiment,}
