% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sentomeasures_measures_xyz.R
\name{measures_fill}
\alias{measures_fill}
\title{Add and fill missing dates}
\usage{
measures_fill(sentomeasures, fill = "zero", dateBefore = NULL,
  dateAfter = NULL)
}
\arguments{
\item{sentomeasures}{a \code{sentomeasures} object created using \code{\link{sento_measures}}.}

\item{fill}{an element of \code{c("zero", "latest")}; the first assumes missing dates represent zero sentiment,
the second assumes missing dates represent constant sentiment.}

\item{dateBefore}{a date as \code{"yyyy-mm-dd"}, to stretch the sentiment time series from up to the first date. Should
be earlier than \code{get_dates(sentomeasures)[1]} to take effect. The values for these dates are set to those at
\code{get_dates(sentomeasures)[1]}. If \code{NULL}, then ignored.}

\item{dateAfter}{a date as \code{"yyyy-mm-dd"}, to stretch the sentiment time series up to this date. Should be
later than \code{tail(get_dates(sentomeasures), 1)} to take effect. If \code{NULL}, then ignored.}
}
\value{
A modified \code{sentomeasures} object.
}
\description{
Adds missing dates between earliest and latest date of a \code{sentomeasures} object or two more extreme
boundary dates, such that the time series are continuous date-wise. Fills in any missing date with either 0 or the
most recent non-missing value.
}
\details{
The \code{dateBefore} and \code{dateAfter} dates are converted according to the \code{sentomeasures[["by"]]}
frequency.
}
\examples{
data("usnews", package = "sentometrics")
data("list_lexicons", package = "sentometrics")
data("list_valence_shifters", package = "sentometrics")

# construct a sentomeasures object to start with
corpus <- sento_corpus(corpusdf = usnews)
corpusSample <- quanteda::corpus_sample(corpus, size = 500)
l <- sento_lexicons(list_lexicons[c("LM_en", "HENRY_en")], list_valence_shifters[["en"]])
ctr <- ctr_agg(howTime = c("equal_weight", "linear"), by = "day", lag = 7, fill = "none")
sentomeasures <- sento_measures(corpusSample, l, ctr)

# fill measures
f1 <- measures_fill(sentomeasures)
f2 <- measures_fill(sentomeasures, fill = "latest")
f3 <- measures_fill(sentomeasures, fill = "zero",
                    dateBefore = get_dates(sentomeasures)[1] - 10,
                    dateAfter = tail(get_dates(sentomeasures), 1) + 15)

}
\author{
Samuel Borms
}
