% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sentomeasures_main.R
\name{aggregate.sentiment}
\alias{aggregate.sentiment}
\title{Aggregate textual sentiment across sentences, documents and time}
\usage{
\method{aggregate}{sentiment}(x, ctr, do.full = TRUE, ...)
}
\arguments{
\item{x}{a \code{sentiment} object created using \code{\link{compute_sentiment}} (from a \code{sento_corpus}
object) or using \code{\link{as.sentiment}}.}

\item{ctr}{output from a \code{\link{ctr_agg}} call. The \code{howWithin} and \code{nCore} elements are ignored.}

\item{do.full}{if \code{do.full = TRUE} (by default), does entire aggregation up to a \code{sento_measures}
object, else only goes from sentence-level to document-level. Ignored if no \code{"sentence_id"} column in
\code{sentiment} input object.}

\item{...}{not used.}
}
\value{
A document-level \code{sentiment} object or a fully aggregated \code{sento_measures} object.
}
\description{
Aggregates textual sentiment scores at sentence- or document-level into a panel of textual
sentiment measures. Can also be used to aggregate sentence-level sentiment scores into
document-level sentiment scores. This function is called within the \code{\link{sento_measures}} function.
}
\examples{
set.seed(505)

data("usnews", package = "sentometrics")
data("list_lexicons", package = "sentometrics")
data("list_valence_shifters", package = "sentometrics")

# computation of sentiment
corpus <- sento_corpus(corpusdf = usnews)
corpusSample <- quanteda::corpus_sample(corpus, size = 500)
l1 <- sento_lexicons(list_lexicons[c("LM_en", "HENRY_en")],
                     list_valence_shifters[["en"]])
l2 <- sento_lexicons(list_lexicons[c("LM_en", "HENRY_en")],
                     list_valence_shifters[["en"]][, c("x", "t")])
sent1 <- compute_sentiment(corpusSample, l1, how = "counts")
sent2 <- compute_sentiment(corpusSample, l2, do.sentence = TRUE)
sent3 <- compute_sentiment(quanteda::texts(corpusSample), l2,
                           do.sentence = TRUE)
ctr <- ctr_agg(howTime = c("linear"), by = "year", lag = 3)

# aggregate into sentiment measures
sm1 <- aggregate(sent1, ctr)
sm2 <- aggregate(sent2, ctr)

# two-step aggregation (first into document-level sentiment)
sd2 <- aggregate(sent2, ctr, do.full = FALSE)
sm3 <- aggregate(sd2, ctr)

# aggregation of a sentiment data.table
cols <- c("word_count", names(l2)[-length(l2)])
sd3 <- sent3[, lapply(.SD, sum), by = "id", .SDcols = cols]

}
\seealso{
\code{\link{compute_sentiment}}, \code{\link{ctr_agg}}, \code{\link{sento_measures}}
}
\author{
Samuel Borms, Keven Bluteau
}
