% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sentocorpus.R
\name{as.sento_corpus}
\alias{as.sento_corpus}
\title{Convert a quanteda or tm corpus object into a sento_corpus object}
\usage{
as.sento_corpus(x, dates = NULL, do.clean = FALSE)
}
\arguments{
\item{x}{a \pkg{quanteda} \code{\link[quanteda]{corpus}} object, a \pkg{tm}
\code{\link[tm]{SimpleCorpus}} or a \pkg{tm} \code{\link[tm]{VCorpus}} object. For \pkg{tm}
corpora, every corpus element should consist of a single \code{"content"} \code{character} vector
as the document unit.}

\item{dates}{an optional sequence of dates as \code{"yyyy-mm-dd"}, of the same length as the number
of documents in the input corpus, to define the \code{"date"} column. If \code{dates = NULL}, the
\code{"date"} metadata element in the input corpus, if available, will be used but should be in the
same \code{"yyyy-mm-dd"} format.}

\item{do.clean}{see \code{\link{sento_corpus}}.}
}
\value{
A \code{sento_corpus} object, as returned by the \code{\link{sento_corpus}} function.
}
\description{
Converts most common \pkg{quanteda} and \pkg{tm} corpus objects into a
\code{sento_corpus} object. Appropriate available metadata is integrated as features;
for a \pkg{quanteda} corpus, this can come from \code{docvars(x)}, for a \pkg{tm} corpus,
only \code{meta(x, type = "indexed")} metadata is considered.
}
\examples{
data("usnews", package = "sentometrics")
txt <- system.file("texts", "txt", package = "tm")
reuters <- system.file("texts", "crude", package = "tm")

# reshuffle usnews data.frame for use in quanteda and tm
dates <- usnews$date
usnews$wrong <- "notNumeric"
colnames(usnews)[c(1, 3)] <- c("doc_id", "text")

# conversion from a quanteda corpus
qcorp <- quanteda::corpus(usnews,
                          text_field = "text", docid_field = "doc_id")
corp1 <- as.sento_corpus(qcorp)
corp2 <- as.sento_corpus(qcorp, sample(dates)) # overwrites "date" column

# conversion from a tm SimpleCorpus corpus (DataframeSource)
tmSCdf <- tm::SimpleCorpus(tm::DataframeSource(usnews))
corp3 <- as.sento_corpus(tmSCdf)

# conversion from a tm SimpleCorpus corpus (DirSource)
tmSCdir <- tm::SimpleCorpus(tm::DirSource(txt))
corp4 <- as.sento_corpus(tmSCdir, dates[1:length(tmSCdir)])

# conversion from a tm VCorpus corpus (DataframeSource)
tmVCdf <- tm::VCorpus(tm::DataframeSource(usnews))
corp5 <- as.sento_corpus(tmVCdf)

# conversion from a tm VCorpus corpus (DirSource)
tmVCdir <- tm::VCorpus(tm::DirSource(reuters),
                       list(reader = tm::readReut21578XMLasPlain))
corp6 <- as.sento_corpus(tmVCdir, dates[1:length(tmVCdir)])

}
\seealso{
\code{\link[quanteda]{corpus}}, \code{\link[tm]{SimpleCorpus}}, \code{\link[tm]{VCorpus}},
\code{\link{sento_corpus}}
}
\author{
Samuel Borms
}
