% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{topWords}
\alias{topWords}
\alias{plot_topWords}
\title{Extract the most representative words from topics}
\usage{
topWords(
  x,
  nWords = 10,
  method = c("frequency", "probability", "term-score", "FREX"),
  output = c("data.frame", "plot", "matrix"),
  subset,
  w = 0.5
)

plot_topWords(
  x,
  nWords = 10,
  method = c("frequency", "probability", "term-score", "FREX"),
  subset,
  w = 0.5
)
}
\arguments{
\item{x}{a \code{sentopicmodel} created from the \code{\link[=LDA]{LDA()}}, \code{\link[=JST]{JST()}} or \code{\link[=rJST]{rJST()}}}

\item{nWords}{the number of top words to extract}

\item{method}{specify if a re-ranking function should be applied before
returning the top words}

\item{output}{determines the output of the function}

\item{subset}{allows to subset using a logical expression, as in \code{\link[=subset]{subset()}}.
Particularly useful to limit the number of observation on plot outputs. The
logical expression uses topic and sentiment \emph{indices} rather than their
label. It is possible to subset on both topic and sentiment but adding a
\code{&} operator between two expressions.}

\item{w}{only used when \code{method = "FREX"}. Determines the weight assigned to
the frequency score at the expense of the exclusivity score.}
}
\value{
The top words of the topic model. Depending on the output chosen, can
result in either a long-style data.frame, a \code{ggplot2} object or a matrix.
}
\description{
Extract the top words in each topic/sentiment from a
\code{sentopicmodel}.
}
\examples{
model <- LDA(ECB_press_conferences_tokens)
model <- grow(model, 10)
topWords(model)
topWords(model, output = "matrix")
topWords(model, method = "FREX")
plot_topWords(model)
plot_topWords(model, subset = topic \%in\% 1:2)

jst <- JST(ECB_press_conferences_tokens)
jst <- grow(jst, 10)
plot_topWords(jst)
plot_topWords(jst, subset = topic \%in\% 1:2 & sentiment == 3)
}
\seealso{
\code{\link[=melt.sentopicmodel]{melt.sentopicmodel()}} for extracting estimated mixtures
}
\author{
Olivier Delmarcelle
}
