% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversions.R
\name{as.tokens.dfm}
\alias{as.tokens.dfm}
\title{Convert back a dfm to a tokens object}
\usage{
\method{as.tokens}{dfm}(
  x,
  concatenator = NULL,
  tokens = NULL,
  ignore_list = NULL,
  case_insensitive = FALSE,
  padding = TRUE,
  ...
)
}
\arguments{
\item{x}{\link[quanteda:dfm]{quanteda::dfm} to be coerced}

\item{concatenator}{only used for consistency with the generic}

\item{tokens}{optionally, the tokens from which the dfm was created.
Providing the initial tokens will ensure that the word order will be
respected in the coerced object.}

\item{ignore_list}{a character vector of words that should not be removed
from the initial tokens object. Useful to avoid removing some lexicon word
following the usage of \code{\link[quanteda:dfm_trim]{quanteda::dfm_trim()}}.}

\item{case_insensitive}{only used when the \code{tokens} argument is provided.
Default to \code{FALSE}. This function removes words in the initial \link{tokens}
based on the remaining features in the \link{dfm} object. This check is
case-sensitive by default, and can be relaxed by setting this argument to
\code{TRUE}.}

\item{padding}{if \code{TRUE}, leaves an empty string where the removed tokens
previously existed. The use of padding is encouraged to improve the
behavior of the coherence metrics (see \code{\link[=coherence]{coherence()}}) that rely on word
positions.}

\item{...}{unused}
}
\value{
a quanteda \link[quanteda:tokens]{quanteda::tokens} object.
}
\description{
Convert back a dfm to a tokens object
}
\examples{
library(quanteda)
dfm <- dfm(ECB_press_conferences_tokens, tolower = FALSE)
dfm <- dfm_trim(dfm, min_termfreq = 200)
as.tokens(dfm)
as.tokens(dfm, tokens = ECB_press_conferences_tokens)
as.tokens(dfm, tokens = ECB_press_conferences_tokens, padding = FALSE)
}
\seealso{
\code{\link[quanteda:as.tokens]{quanteda::as.tokens()}} \code{\link[quanteda:dfm]{quanteda::dfm()}}
}
