% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arrange_se.R
\name{arrange_se}
\alias{arrange_se}
\title{arrange standard interface.}
\usage{
arrange_se(.data, arrangeTerms)
}
\arguments{
\item{.data}{data.frame}

\item{arrangeTerms}{character vector of column expressions to arrange by.}
}
\value{
.data grouped by columns named in groupingVars
}
\description{
Arange a data frame by the arrangeTerms.  Accepts arbitrary text as
arrangeTerms to allow forms such as "desc(gear)"
(unlike \code{\link[dplyr]{arrange_at}}).
}
\examples{

datasets::mtcars \%>\%
  arrange_se(c("cyl", "desc(gear)")) \%>\%
  head()
# roughly equivilent to:
# arrange(datasets::mtcars, cyl, desc(gear)) \%>\% head()

}
\seealso{
\code{\link[dplyr]{arrange}}, \code{\link[dplyr]{arrange_at}}
}
